/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.gui.orderer;

import logisticspipes.gui.orderer.GuiOrderer;
import logisticspipes.interfaces.ISlotClick;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.orderer.OrdererRefreshRequestPacket;
import logisticspipes.network.packets.orderer.RequestSubmitPacket;
import logisticspipes.pipes.PipeBlockRequestTable;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.SimpleInventory;
import logisticspipes.utils.gui.BasicGuiHelper;
import logisticspipes.utils.gui.DummyContainer;
import logisticspipes.utils.gui.KraphtBaseGuiScreen;
import logisticspipes.utils.gui.SmallGuiButton;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class GuiRequestTable
extends GuiOrderer {
    protected DisplayOptions displayOptions = DisplayOptions.Both;
    public final PipeBlockRequestTable _table;

    public GuiRequestTable(EntityPlayer entityPlayer, PipeBlockRequestTable table) {
        super(table.xCoord, table.yCoord, table.zCoord, MainProxy.getDimensionForWorld(table.worldObj), entityPlayer);
        int x;
        int y;
        this._table = table;
        this.field_74194_b += this.getLeftAddition();
        DummyContainer dummy = new DummyContainer((IInventory)entityPlayer.field_71071_by, this._table.matrix);
        int i = 0;
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                dummy.addNormalSlot(i++, this._table.inv, this.field_74198_m + x * 18 + 20, this.field_74197_n + y * 18 + 80);
            }
        }
        i = 0;
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 3; ++x) {
                dummy.addDummySlot(i++, this.field_74198_m + x * 18 + 20, this.field_74197_n + y * 18 + 15);
            }
        }
        dummy.addCallableSlotHandler(0, this._table.resultInv, this.field_74198_m + 101, this.field_74197_n + 33, new ISlotClick(){

            @Override
            public ItemStack getResultForClick() {
                GuiRequestTable.this._table.inv.addCompressed(GuiRequestTable.this._table.getOutput());
                return null;
            }
        });
        dummy.addNormalSlot(0, this._table.toSortInv, this.field_74198_m + 164, this.field_74197_n + 51);
        dummy.addNormalSlotsForPlayerInventory(20, 150);
        this.field_74193_d = dummy;
        this.refreshItems();
    }

    @Override
    protected int getLeftAddition() {
        return 200;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_74198_m += this.getLeftAddition();
        this.field_73887_h.add(new SmallGuiButton(3, this.field_74198_m + 10, this.bottom - 15, 46, 10, "Refresh"));
        this.field_73887_h.add(new SmallGuiButton(13, this.field_74198_m + 10, this.bottom - 28, 46, 10, "Content"));
        this.field_73887_h.add(new SmallGuiButton(9, this.field_74198_m + 10, this.bottom - 41, 46, 10, "Both"));
        this.field_74198_m -= this.getLeftAddition();
        this.field_73887_h.add(new SmallGuiButton(14, this.field_74198_m + 75, this.field_74197_n + 55, 46, 10, "Request"));
    }

    @Override
    public void func_74185_a(float f, int i, int j) {
        int a;
        int y;
        int x;
        super.func_74185_a(f, i, j);
        for (x = 0; x < 9; ++x) {
            for (y = 0; y < 3; ++y) {
                BasicGuiHelper.drawSlotBackground(this.field_73882_e, this.field_74198_m + x * 18 + 19, this.field_74197_n + y * 18 + 79);
            }
        }
        for (x = 0; x < 3; ++x) {
            for (y = 0; y < 3; ++y) {
                BasicGuiHelper.drawSlotBackground(this.field_73882_e, this.field_74198_m + x * 18 + 19, this.field_74197_n + y * 18 + 14);
            }
        }
        BasicGuiHelper.drawSlotBackground(this.field_73882_e, this.field_74198_m + 100, this.field_74197_n + 32);
        BasicGuiHelper.drawSlotBackground(this.field_73882_e, this.field_74198_m + 163, this.field_74197_n + 50);
        this.drawRect(this.field_74198_m + 75, this.field_74197_n + 38, this.field_74198_m + 95, this.field_74197_n + 43, KraphtBaseGuiScreen.Colors.DarkGrey);
        for (a = 0; a < 10; ++a) {
            this.drawRect(this.field_74198_m + 97 - a, this.field_74197_n + 40 - a, this.field_74198_m + 98 - a, this.field_74197_n + 41 + a, KraphtBaseGuiScreen.Colors.DarkGrey);
        }
        for (a = 0; a < 15; ++a) {
            this.drawRect(this.field_74198_m + 164 + a, this.field_74197_n + 51 + a, this.field_74198_m + 166 + a, this.field_74197_n + 53 + a, KraphtBaseGuiScreen.Colors.DarkGrey);
            this.drawRect(this.field_74198_m + 164 + a, this.field_74197_n + 65 - a, this.field_74198_m + 166 + a, this.field_74197_n + 67 - a, KraphtBaseGuiScreen.Colors.DarkGrey);
        }
        BasicGuiHelper.drawPlayerInventoryBackground(this.field_73882_e, this.field_74198_m + 20, this.field_74197_n + 150);
    }

    @Override
    public void refreshItems() {
        switch (this.displayOptions) {
            case Both: {
                int integer = 0;
                break;
            }
            case SupplyOnly: {
                int integer = 1;
                break;
            }
            case CraftOnly: {
                int integer = 2;
                break;
            }
            default: {
                int integer = 3;
            }
        }
        MainProxy.sendPacketToServer(((OrdererRefreshRequestPacket)PacketHandler.getPacket(OrdererRefreshRequestPacket.class)).setInteger(integer += this.dimension * 10).setPosX(this.xCoord).setPosY(this.yCoord).setPosZ(this.zCoord));
    }

    @Override
    protected void func_73875_a(GuiButton guibutton) {
        super.func_73875_a(guibutton);
        if (guibutton.field_73741_f == 9) {
            String displayString = "";
            switch (this.displayOptions) {
                case Both: {
                    this.displayOptions = DisplayOptions.CraftOnly;
                    displayString = "Craft";
                    break;
                }
                case CraftOnly: {
                    this.displayOptions = DisplayOptions.SupplyOnly;
                    displayString = "Supply";
                    break;
                }
                case SupplyOnly: {
                    this.displayOptions = DisplayOptions.Both;
                    displayString = "Both";
                }
            }
            guibutton.field_73744_e = displayString;
            this.refreshItems();
        } else if (guibutton.field_73741_f == 14) {
            int i;
            SimpleInventory compress = new SimpleInventory(9, "", Integer.MAX_VALUE);
            for (i = 0; i < 9; ++i) {
                compress.addCompressed(this._table.matrix.func_70301_a(i));
            }
            for (i = 0; i < 9; ++i) {
                ItemStack slot = compress.func_70301_a(i);
                if (slot == null) continue;
                MainProxy.sendPacketToServer(((RequestSubmitPacket)PacketHandler.getPacket(RequestSubmitPacket.class)).setDimension(this.dimension).setStack(ItemIdentifierStack.GetFromStack(slot)).setPosX(this.xCoord).setPosY(this.yCoord).setPosZ(this.zCoord));
            }
            this.refreshItems();
        }
    }

    @Override
    public void specialItemRendering(ItemIdentifier item, int x, int y) {
    }

    private static enum DisplayOptions {
        Both,
        SupplyOnly,
        CraftOnly;

    }
}

