/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.gui.modules;

import buildcraft.transport.Pipe;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import logisticspipes.gui.modules.GuiWithPreviousGuiContainer;
import logisticspipes.modules.ModuleApiaristSink;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.module.BeeModuleSetBeePacket;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.gui.BasicGuiHelper;
import logisticspipes.utils.gui.DummyContainer;
import logisticspipes.utils.gui.IItemTextureRenderSlot;
import logisticspipes.utils.gui.ISmallColorRenderSlot;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.Icon;

public class GuiApiaristSink
extends GuiWithPreviousGuiContainer {
    private final ModuleApiaristSink module;
    private int slot;

    public GuiApiaristSink(ModuleApiaristSink module, EntityPlayer player, Pipe pipe, GuiScreen previousGui, int slot) {
        super(new DummyContainer((IInventory)player.field_71071_by, null), pipe, previousGui);
        this.module = module;
        this.slot = slot;
        for (int i = 0; i < 6; ++i) {
            ModuleApiaristSink.SinkSetting filter = module.filter[i];
            this.addRenderSlot(new TypeSlot(20, 20 + i * 18, filter, i, this));
            this.addRenderSlot(new GroupSlot(this.field_74198_m + 45, this.field_74197_n + 25 + i * 18, filter, i, this));
            this.addRenderSlot(new BeeSlot(60, 20 + i * 18, filter, 0, i, this));
            this.addRenderSlot(new BeeSlot(78, 20 + i * 18, filter, 1, i, this));
        }
        this.field_74194_b = 120;
        this.field_74195_c = 150;
    }

    protected void func_74185_a(float var1, int var2, int var3) {
        BasicGuiHelper.drawGuiBackGround(this.field_73882_e, this.field_74198_m, this.field_74197_n, this.right, this.bottom, this.field_73735_i, true);
    }

    @Override
    public int getGuiID() {
        return 28;
    }

    private class BeeSlot
    extends IItemTextureRenderSlot {
        private final int xPos;
        private final int yPos;
        private final ModuleApiaristSink.SinkSetting setting;
        private final int slotNumber;
        private final int row;
        private final GuiApiaristSink gui;

        private BeeSlot(int xPos, int yPos, ModuleApiaristSink.SinkSetting setting, int slotNumber, int row, GuiApiaristSink guiApiaristSink2) {
            this.xPos = xPos;
            this.yPos = yPos;
            this.setting = setting;
            this.slotNumber = slotNumber;
            this.row = row;
            this.gui = guiApiaristSink2;
        }

        @Override
        public void mouseClicked(int button) {
            if (button == 2) {
                if (this.slotNumber == 0) {
                    this.setting.firstBeeReset();
                } else {
                    this.setting.secondBeeReset();
                }
            }
            if (button == 0) {
                if (this.slotNumber == 0) {
                    this.setting.firstBeeUp();
                } else {
                    this.setting.secondBeeUp();
                }
            }
            if (button == 1) {
                if (this.slotNumber == 0) {
                    this.setting.firstBeeDown();
                } else {
                    this.setting.secondBeeDown();
                }
            }
            MainProxy.sendPacketToServer(((BeeModuleSetBeePacket)PacketHandler.getPacket(BeeModuleSetBeePacket.class)).setInteger1(this.gui.slot).setInteger2(this.row).setInteger3(this.slotNumber).setString1(this.slotNumber == 0 ? this.setting.firstBee : this.setting.secondBee).setPosX(GuiApiaristSink.this.module.getX()).setPosY(GuiApiaristSink.this.module.getY()).setPosZ(GuiApiaristSink.this.module.getZ()));
        }

        @Override
        public boolean drawSlotBackground() {
            return this.setting.filterType.secondSlots > this.slotNumber;
        }

        @Override
        public int getXPos() {
            return this.xPos;
        }

        @Override
        public int getYPos() {
            return this.yPos;
        }

        @Override
        public boolean drawSlotIcon() {
            return this.drawSlotBackground() && !(this.slotNumber == 0 ? this.setting.firstBee : this.setting.secondBee).isEmpty();
        }

        @Override
        public String getToolTipText() {
            return SimpleServiceLocator.forestryProxy.getAlleleName(this.slotNumber == 0 ? this.setting.firstBee : this.setting.secondBee);
        }

        @Override
        public boolean displayToolTip() {
            if (this.slotNumber == 0) {
                return this.setting.firstBee != "" && this.drawSlotBackground();
            }
            return this.setting.secondBee != "" && this.drawSlotBackground();
        }

        @Override
        public boolean customRender(Minecraft mc, float zLevel) {
            if (this.slotNumber == 0) {
                BasicGuiHelper.renderForestryBeeAt(mc, this.xPos + 1, this.yPos + 1, zLevel, this.setting.firstBee);
            } else {
                BasicGuiHelper.renderForestryBeeAt(mc, this.xPos + 1, this.yPos + 1, zLevel, this.setting.secondBee);
            }
            return true;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public Icon getTextureIcon() {
            return null;
        }
    }

    private class GroupSlot
    extends ISmallColorRenderSlot {
        private final int xPos;
        private final int yPos;
        private final ModuleApiaristSink.SinkSetting setting;
        private final int row;
        private final GuiApiaristSink gui;

        private GroupSlot(int xPos, int yPos, ModuleApiaristSink.SinkSetting setting, int row, GuiApiaristSink guiApiaristSink2) {
            this.xPos = xPos;
            this.yPos = yPos;
            this.setting = setting;
            this.row = row;
            this.gui = guiApiaristSink2;
        }

        @Override
        public void mouseClicked(int button) {
            if (button == 2) {
                this.setting.filterGroupReset();
            }
            if (button == 0) {
                this.setting.filterGroupUp();
            }
            if (button == 1) {
                this.setting.filterGroupDown();
            }
            MainProxy.sendPacketToServer(((BeeModuleSetBeePacket)PacketHandler.getPacket(BeeModuleSetBeePacket.class)).setInteger1(this.gui.slot).setInteger2(this.row).setInteger3(2).setInteger4(this.setting.filterGroup).setPosX(GuiApiaristSink.this.module.getX()).setPosY(GuiApiaristSink.this.module.getY()).setPosZ(GuiApiaristSink.this.module.getZ()));
        }

        @Override
        public boolean drawSlotBackground() {
            return this.setting.filterType != ModuleApiaristSink.FilterType.Null;
        }

        @Override
        public int getXPos() {
            return this.xPos;
        }

        @Override
        public int getYPos() {
            return this.yPos;
        }

        @Override
        public String getToolTipText() {
            switch (this.setting.filterGroup) {
                case 1: {
                    return "GroupColor: Red";
                }
                case 2: {
                    return "GroupColor: Green";
                }
                case 3: {
                    return "GroupColor: Blue";
                }
                case 4: {
                    return "GroupColor: Yellow";
                }
                case 5: {
                    return "GroupColor: Cyan";
                }
                case 6: {
                    return "GroupColor: Purple";
                }
            }
            return "No Group";
        }

        @Override
        public boolean displayToolTip() {
            return this.drawSlotBackground();
        }

        @Override
        public int getColor() {
            switch (this.setting.filterGroup) {
                case 1: {
                    return -65536;
                }
                case 2: {
                    return -16711936;
                }
                case 3: {
                    return -16776961;
                }
                case 4: {
                    return -256;
                }
                case 5: {
                    return -16711681;
                }
                case 6: {
                    return -65281;
                }
            }
            return 0;
        }

        @Override
        public boolean drawColor() {
            return this.drawSlotBackground();
        }
    }

    private class TypeSlot
    extends IItemTextureRenderSlot {
        private final int xPos;
        private final int yPos;
        private final ModuleApiaristSink.SinkSetting setting;
        private final int row;
        private final GuiApiaristSink gui;

        private TypeSlot(int xPos, int yPos, ModuleApiaristSink.SinkSetting setting, int row, GuiApiaristSink guiApiaristSink2) {
            this.xPos = xPos;
            this.yPos = yPos;
            this.setting = setting;
            this.row = row;
            this.gui = guiApiaristSink2;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public Icon getTextureIcon() {
            if (this.setting.filterType == null) {
                return null;
            }
            return SimpleServiceLocator.forestryProxy.getIconFromTextureManager("analyzer/" + this.setting.filterType.icon);
        }

        @Override
        public void mouseClicked(int button) {
            if (button == 2) {
                this.setting.FilterTypeReset();
            }
            if (button == 0) {
                this.setting.FilterTypeUp();
            }
            if (button == 1) {
                this.setting.FilterTypeDown();
            }
            MainProxy.sendPacketToServer(((BeeModuleSetBeePacket)PacketHandler.getPacket(BeeModuleSetBeePacket.class)).setInteger1(this.gui.slot).setInteger2(this.row).setInteger3(3).setInteger4(this.setting.filterType.ordinal()).setPosX(GuiApiaristSink.this.module.getX()).setPosY(GuiApiaristSink.this.module.getY()).setPosZ(GuiApiaristSink.this.module.getZ()));
        }

        @Override
        public boolean drawSlotBackground() {
            return true;
        }

        @Override
        public int getXPos() {
            return this.xPos;
        }

        @Override
        public int getYPos() {
            return this.yPos;
        }

        @Override
        public boolean drawSlotIcon() {
            return true;
        }

        @Override
        public String getToolTipText() {
            if (this.setting.filterType == null) {
                return "";
            }
            return SimpleServiceLocator.forestryProxy.getForestryTranslation(this.setting.filterType.path);
        }

        @Override
        public boolean displayToolTip() {
            return this.setting.filterType != ModuleApiaristSink.FilterType.Null;
        }

        @Override
        public boolean customRender(Minecraft mc, float zLevel) {
            return false;
        }
    }
}

