/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.blocks.powertile;

import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IPeripheral;
import ic2.api.Direction;
import ic2.api.energy.tile.IEnergySink;
import java.util.List;
import logisticspipes.api.ILogisticsPowerProvider;
import logisticspipes.asm.ModDependentInterface;
import logisticspipes.asm.ModDependentMethod;
import logisticspipes.config.Configs;
import logisticspipes.gui.hud.HUDPowerJunction;
import logisticspipes.interfaces.IBlockWatchingHandler;
import logisticspipes.interfaces.IGuiOpenControler;
import logisticspipes.interfaces.IHeadUpDisplayBlockRendererProvider;
import logisticspipes.interfaces.IHeadUpDisplayRenderer;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.block.PowerJunctionLevel;
import logisticspipes.network.packets.hud.HUDStartBlockWatchingPacket;
import logisticspipes.network.packets.hud.HUDStopBlockWatchingPacket;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.renderer.LogisticsHUDRenderer;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.gui.DummyContainer;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

@ModDependentInterface(modId={"IC2", "ComputerCraft"}, interfacePath={"ic2.api.energy.tile.IEnergySink", "dan200.computer.api.IPeripheral"})
public class LogisticsPowerJunctionTileEntity
extends TileEntity
implements IPowerReceptor,
ILogisticsPowerProvider,
IGuiOpenControler,
IHeadUpDisplayBlockRendererProvider,
IBlockWatchingHandler,
IEnergySink,
IPeripheral {
    public boolean needMorePowerTriggerCheck = true;
    public final int BuildCraftMultiplier = 5;
    public final int IC2Multiplier = 2;
    public final int MAX_STORAGE = 2000000;
    private IPowerProvider powerFramework;
    private PlayerCollectionList guiListener = new PlayerCollectionList();
    private int internalStorage = 0;
    private int lastUpdateStorage = 0;
    private int internalBuffer = 0;
    private boolean addedToEnergyNet = false;
    private boolean init = false;
    private PlayerCollectionList watcherList = new PlayerCollectionList();
    private IHeadUpDisplayRenderer HUD;

    public LogisticsPowerJunctionTileEntity() {
        this.powerFramework = PowerFramework.currentFramework.createPowerProvider();
        this.powerFramework.configure(0, 1, 250, 1, 750);
        this.HUD = new HUDPowerJunction(this);
    }

    @Override
    public boolean useEnergy(int amount, List providersToIgnore) {
        if (providersToIgnore != null && providersToIgnore.contains(this)) {
            return false;
        }
        if (this.canUseEnergy(amount, null)) {
            this.internalStorage -= amount * Configs.POWER_USAGE_MULTIPLIER;
            if (this.internalStorage < 1000000) {
                this.needMorePowerTriggerCheck = true;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canUseEnergy(int amount, List providersToIgnore) {
        if (providersToIgnore != null && providersToIgnore.contains(this)) {
            return false;
        }
        return this.internalStorage >= amount * Configs.POWER_USAGE_MULTIPLIER;
    }

    @Override
    public boolean useEnergy(int amount) {
        return this.useEnergy(amount, null);
    }

    public int freeSpace() {
        return 2000000 - this.internalStorage;
    }

    public void updateClients() {
        MainProxy.sendToPlayerList(((PowerJunctionLevel)PacketHandler.getPacket(PowerJunctionLevel.class)).setInteger(this.internalStorage).setPosX(this.field_70329_l).setPosY(this.field_70330_m).setPosZ(this.field_70327_n), this.guiListener);
        MainProxy.sendToPlayerList(((PowerJunctionLevel)PacketHandler.getPacket(PowerJunctionLevel.class)).setInteger(this.internalStorage).setPosX(this.field_70329_l).setPosY(this.field_70330_m).setPosZ(this.field_70327_n), this.watcherList);
        this.lastUpdateStorage = this.internalStorage;
    }

    @Override
    public boolean canUseEnergy(int amount) {
        return this.canUseEnergy(amount, null);
    }

    public void addEnergy(float amount) {
        if (MainProxy.isClient(this.getWorld())) {
            return;
        }
        this.internalStorage = (int)((float)this.internalStorage + amount);
        if (this.internalStorage > 2000000) {
            this.internalStorage = 2000000;
        }
        if (this.internalStorage == 2000000) {
            this.needMorePowerTriggerCheck = false;
        }
    }

    public void func_70307_a(NBTTagCompound par1nbtTagCompound) {
        super.func_70307_a(par1nbtTagCompound);
        this.internalStorage = par1nbtTagCompound.func_74762_e("powerLevel");
        if (par1nbtTagCompound.func_74764_b("needMorePowerTriggerCheck")) {
            this.needMorePowerTriggerCheck = par1nbtTagCompound.func_74767_n("needMorePowerTriggerCheck");
        }
    }

    public void func_70310_b(NBTTagCompound par1nbtTagCompound) {
        super.func_70310_b(par1nbtTagCompound);
        par1nbtTagCompound.func_74768_a("powerLevel", this.internalStorage);
        par1nbtTagCompound.func_74757_a("needMorePowerTriggerCheck", this.needMorePowerTriggerCheck);
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (MainProxy.isServer(this.field_70331_k)) {
            float energy = Math.min(this.powerFramework.getEnergyStored(), (float)(this.freeSpace() / 5));
            if (this.freeSpace() > 0 && energy == 0.0f && this.powerFramework.getEnergyStored() > 0.0f) {
                energy = 1.0f;
            }
            if (this.powerFramework.useEnergy(energy, energy, false) == energy) {
                this.powerFramework.useEnergy(energy, energy, true);
                this.addEnergy(energy * 5.0f);
            }
            if (this.internalStorage != this.lastUpdateStorage) {
                this.updateClients();
            }
        }
        if (!this.init) {
            if (MainProxy.isClient(this.field_70331_k)) {
                LogisticsHUDRenderer.instance().add(this);
            }
            if (!this.addedToEnergyNet) {
                SimpleServiceLocator.IC2Proxy.registerToEneryNet(this);
                this.addedToEnergyNet = true;
            }
            this.init = true;
        }
    }

    public void func_70313_j() {
        super.func_70313_j();
        if (MainProxy.isClient(this.field_70331_k)) {
            LogisticsHUDRenderer.instance().remove(this);
        }
        if (this.addedToEnergyNet) {
            SimpleServiceLocator.IC2Proxy.unregisterToEneryNet(this);
            this.addedToEnergyNet = false;
        }
    }

    public void func_70312_q() {
        super.func_70312_q();
        if (MainProxy.isClient(this.field_70331_k)) {
            this.init = false;
        }
        if (!this.addedToEnergyNet) {
            this.init = false;
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (MainProxy.isClient(this.field_70331_k)) {
            LogisticsHUDRenderer.instance().remove(this);
        }
        if (this.addedToEnergyNet) {
            SimpleServiceLocator.IC2Proxy.unregisterToEneryNet(this);
            this.addedToEnergyNet = false;
        }
    }

    public void setPowerProvider(IPowerProvider provider) {
        this.powerFramework = provider;
    }

    public IPowerProvider getPowerProvider() {
        return this.powerFramework;
    }

    public void doWork() {
    }

    public int powerRequest(ForgeDirection from) {
        return Math.min(this.powerFramework.getMaxEnergyReceived(), this.freeSpace() / 5);
    }

    @Override
    public int getPowerLevel() {
        return this.internalStorage;
    }

    public int getChargeState() {
        return this.internalStorage * 100 / 2000000;
    }

    public Container createContainer(EntityPlayer player) {
        DummyContainer dummy = new DummyContainer(player, null, this);
        dummy.addNormalSlotsForPlayerInventory(8, 80);
        return dummy;
    }

    @Override
    public void guiOpenedByPlayer(EntityPlayer player) {
        this.guiListener.add(player);
        this.updateClients();
    }

    @Override
    public void guiClosedByPlayer(EntityPlayer player) {
        this.guiListener.remove(player);
    }

    public void handlePowerPacket(int integer) {
        if (MainProxy.isClient(this.field_70331_k)) {
            this.internalStorage = integer;
        }
    }

    @Override
    public IHeadUpDisplayRenderer getRenderer() {
        return this.HUD;
    }

    @Override
    public int getX() {
        return this.field_70329_l;
    }

    @Override
    public int getY() {
        return this.field_70330_m;
    }

    @Override
    public int getZ() {
        return this.field_70327_n;
    }

    @Override
    public World getWorld() {
        return this.field_70331_k;
    }

    @Override
    public void startWatching() {
        MainProxy.sendPacketToServer(((HUDStartBlockWatchingPacket)PacketHandler.getPacket(HUDStartBlockWatchingPacket.class)).setPosX(this.field_70329_l).setPosY(this.field_70330_m).setPosZ(this.field_70327_n));
    }

    @Override
    public void stopWatching() {
        MainProxy.sendPacketToServer(((HUDStopBlockWatchingPacket)PacketHandler.getPacket(HUDStopBlockWatchingPacket.class)).setPosX(this.field_70329_l).setPosY(this.field_70330_m).setPosZ(this.field_70327_n));
    }

    @Override
    public void playerStartWatching(EntityPlayer player) {
        this.watcherList.add(player);
        this.updateClients();
    }

    @Override
    public void playerStopWatching(EntityPlayer player) {
        this.watcherList.remove(player);
    }

    @Override
    public boolean isExistent() {
        return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) == this;
    }

    public void func_85027_a(CrashReportCategory par1CrashReportCategory) {
        super.func_85027_a(par1CrashReportCategory);
        par1CrashReportCategory.func_71507_a("LP-Version", (Object)"0.7.3.ftb.631:false");
    }

    @ModDependentMethod(modId="IC2")
    public boolean acceptsEnergyFrom(TileEntity emitter, Direction direction) {
        return true;
    }

    @ModDependentMethod(modId="IC2")
    public boolean isAddedToEnergyNet() {
        return this.addedToEnergyNet;
    }

    @ModDependentMethod(modId="IC2")
    public int demandsEnergy() {
        if (!this.addedToEnergyNet) {
            return 0;
        }
        if (this.internalBuffer > 0 && this.freeSpace() > 0) {
            this.internalBuffer = this.injectEnergy(null, this.internalBuffer);
        }
        return this.freeSpace();
    }

    @ModDependentMethod(modId="IC2")
    public int injectEnergy(Direction directionFrom, int amount) {
        int addAmount = Math.min(amount, this.freeSpace() / 2);
        if (this.freeSpace() > 0 && addAmount == 0) {
            addAmount = 1;
        }
        if (!this.addedToEnergyNet) {
            addAmount = 0;
        }
        this.addEnergy(addAmount * 2);
        if (addAmount == 0 && directionFrom != null) {
            this.internalBuffer += amount;
            return 0;
        }
        return amount - addAmount;
    }

    @ModDependentMethod(modId="IC2")
    public int getMaxSafeInput() {
        return Integer.MAX_VALUE;
    }

    @ModDependentMethod(modId="ComputerCraft")
    public String getType() {
        return "LogisticsPowerJunction";
    }

    @ModDependentMethod(modId="ComputerCraft")
    public String[] getMethodNames() {
        return new String[]{"getPowerLevel"};
    }

    @ModDependentMethod(modId="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        return new Object[]{this.getPowerLevel()};
    }

    @ModDependentMethod(modId="ComputerCraft")
    public boolean canAttachToSide(int side) {
        return true;
    }

    @ModDependentMethod(modId="ComputerCraft")
    public void attach(IComputerAccess computer) {
    }

    @ModDependentMethod(modId="ComputerCraft")
    public void detach(IComputerAccess computer) {
    }
}

