/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.blocks.crafting;

import logisticspipes.api.IRoutedPowerProvider;
import logisticspipes.blocks.crafting.AutoCraftingInventory;
import logisticspipes.config.Configs;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.CraftingUtil;
import logisticspipes.utils.ISimpleInventoryEventHandler;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.SimpleInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class LogisticsCraftingTableTileEntity
extends TileEntity
implements ISimpleInventoryEventHandler,
IInventory {
    public SimpleInventory inv = new SimpleInventory(18, "Crafting Resources", 64);
    public SimpleInventory matrix = new SimpleInventory(9, "Crafting Matrix", 1);
    public SimpleInventory resultInv = new SimpleInventory(1, "Crafting Result", 1);
    private IRecipe cache;
    private EntityPlayer fake;

    public LogisticsCraftingTableTileEntity() {
        this.matrix.addListener(this);
    }

    public void cacheRecipe() {
        this.cache = null;
        this.resultInv.func_70299_a(0, null);
        AutoCraftingInventory craftInv = new AutoCraftingInventory();
        for (int i = 0; i < 9; ++i) {
            craftInv.func_70299_a(i, this.matrix.func_70301_a(i));
        }
        for (IRecipe r : CraftingUtil.getRecipeList()) {
            if (!r.func_77569_a((InventoryCrafting)craftInv, this.field_70331_k)) continue;
            this.cache = r;
            this.resultInv.func_70299_a(0, r.func_77572_b((InventoryCrafting)craftInv));
        }
    }

    public ItemStack getOutput(ItemIdentifier wanted, IRoutedPowerProvider power) {
        ItemStack left;
        int i;
        int j;
        if (this.cache == null) {
            this.cacheRecipe();
            if (this.cache == null) {
                return null;
            }
        }
        int[] toUse = new int[9];
        int[] used = new int[this.inv.func_70302_i_()];
        block0: for (int i2 = 0; i2 < 9; ++i2) {
            ItemStack item = this.matrix.func_70301_a(i2);
            if (item == null) {
                toUse[i2] = -1;
                continue;
            }
            ItemIdentifier ident = ItemIdentifier.get(item);
            for (j = 0; j < this.inv.func_70302_i_(); ++j) {
                item = this.inv.func_70301_a(j);
                if (item == null || !ident.equalsForCrafting(ItemIdentifier.get(item)) || item.field_77994_a <= used[j]) continue;
                int n = j;
                used[n] = used[n] + 1;
                toUse[i2] = j;
                continue block0;
            }
            return null;
        }
        AutoCraftingInventory crafter = new AutoCraftingInventory();
        for (int i3 = 0; i3 < 9; ++i3) {
            int j2 = toUse[i3];
            if (j2 == -1) continue;
            crafter.func_70299_a(i3, this.inv.func_70301_a(j2));
        }
        ItemStack result = this.cache.func_77572_b((InventoryCrafting)crafter);
        if (result == null) {
            return null;
        }
        if (!ItemIdentifier.get(this.resultInv.func_70301_a(0)).equalsWithoutNBT(ItemIdentifier.get(result))) {
            return null;
        }
        if (!wanted.equalsWithoutNBT(ItemIdentifier.get(result))) {
            return null;
        }
        if (!power.useEnergy(Configs.LOGISTICS_CRAFTING_TABLE_POWER_USAGE)) {
            return null;
        }
        crafter = new AutoCraftingInventory();
        for (int i4 = 0; i4 < 9; ++i4) {
            j = toUse[i4];
            if (j == -1) continue;
            crafter.func_70299_a(i4, this.inv.func_70298_a(j, 1));
        }
        result = this.cache.func_77572_b((InventoryCrafting)crafter);
        if (this.fake == null) {
            this.fake = MainProxy.getFakePlayer(this);
        }
        result = result.func_77946_l();
        SlotCrafting craftingSlot = new SlotCrafting(this.fake, (IInventory)crafter, (IInventory)this.resultInv, 0, 0, 0);
        craftingSlot.func_82870_a(this.fake, result);
        for (i = 0; i < 9; ++i) {
            left = crafter.func_70301_a(i);
            crafter.func_70299_a(i, null);
            if (left == null) continue;
            this.inv.addCompressed(left);
        }
        for (i = 0; i < this.fake.field_71071_by.func_70302_i_(); ++i) {
            left = this.fake.field_71071_by.func_70301_a(i);
            this.fake.field_71071_by.func_70299_a(i, null);
            if (left == null) continue;
            this.inv.addCompressed(left);
        }
        return result;
    }

    public void onBlockBreak() {
        this.inv.dropContents(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public void InventoryChanged(SimpleInventory inventory) {
        if (inventory == this.matrix) {
            this.cacheRecipe();
        }
    }

    public void handleNEIRecipePacket(ItemStack[] content) {
        for (int i = 0; i < 9; ++i) {
            this.matrix.func_70299_a(i, content[i]);
        }
        this.cacheRecipe();
    }

    public void func_70307_a(NBTTagCompound par1nbtTagCompound) {
        super.func_70307_a(par1nbtTagCompound);
        this.inv.readFromNBT(par1nbtTagCompound, "inv");
        this.matrix.readFromNBT(par1nbtTagCompound, "matrix");
        this.cacheRecipe();
    }

    public void func_70310_b(NBTTagCompound par1nbtTagCompound) {
        super.func_70310_b(par1nbtTagCompound);
        this.inv.writeToNBT(par1nbtTagCompound, "inv");
        this.matrix.writeToNBT(par1nbtTagCompound, "matrix");
    }

    public int func_70302_i_() {
        return this.inv.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this.inv.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.inv.func_70298_a(i, j);
    }

    public ItemStack func_70304_b(int i) {
        return this.inv.func_70304_b(i);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inv.func_70299_a(i, itemstack);
    }

    public String func_70303_b() {
        return "LogisticsCraftingTable";
    }

    public boolean func_94042_c() {
        return false;
    }

    public int func_70297_j_() {
        return this.inv.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        ItemStack stack;
        if (i < 9 && i >= 0 && (stack = this.matrix.func_70301_a(i)) != null && itemstack != null) {
            return ItemIdentifier.get(stack).equalsWithoutNBT(ItemIdentifier.get(itemstack));
        }
        return true;
    }
}

