/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.blocks;

import buildcraft.api.inventory.ISpecialInventory;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import java.util.LinkedList;
import java.util.List;
import logisticspipes.interfaces.ICraftingResultHandler;
import logisticspipes.interfaces.IGuiOpenControler;
import logisticspipes.interfaces.IRotationProvider;
import logisticspipes.interfaces.ISlotCheck;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.block.RequestRotationPacket;
import logisticspipes.network.packets.block.SolderingStationHeat;
import logisticspipes.network.packets.block.SolderingStationInventory;
import logisticspipes.network.packets.block.SolderingStationProgress;
import logisticspipes.proxy.MainProxy;
import logisticspipes.recipes.SolderingStationRecipes;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.SimpleInventory;
import logisticspipes.utils.gui.DummyContainer;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class LogisticsSolderingTileEntity
extends TileEntity
implements IPowerReceptor,
ISpecialInventory,
IGuiOpenControler,
IRotationProvider {
    private IPowerProvider provider;
    private SimpleInventory inv = new SimpleInventory(12, "Soldering Inventory", 64);
    public int heat = 0;
    public int progress = 0;
    public boolean hasWork = false;
    public int rotation = 0;
    private boolean init = false;
    private PlayerCollectionList listener = new PlayerCollectionList();

    public LogisticsSolderingTileEntity() {
        this.provider = PowerFramework.currentFramework.createPowerProvider();
        this.provider.configure(10, 10, 100, 10, 100);
    }

    public Container createContainer(EntityPlayer player) {
        DummyContainer dummy = new DummyContainer(player, (IInventory)this, this);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                final int slotNumber = i * 3 + j;
                dummy.addRestrictedSlot(slotNumber, (IInventory)this, 44 + j * 18, 17 + i * 18, new ISlotCheck(){

                    @Override
                    public boolean isStackAllowed(ItemStack itemStack) {
                        return LogisticsSolderingTileEntity.this.checkSlot(itemStack, slotNumber);
                    }
                });
            }
        }
        dummy.addRestrictedSlot(9, (IInventory)this, 107, 17, Item.field_77703_o.field_77779_bT);
        dummy.addRestrictedSlot(10, (IInventory)this, 141, 47, -1);
        dummy.addRestrictedSlot(11, (IInventory)this, 9, 9, new ISlotCheck(){

            @Override
            public boolean isStackAllowed(ItemStack itemStack) {
                return LogisticsSolderingTileEntity.this.getRecipeForTaget(itemStack) != null && LogisticsSolderingTileEntity.this.areStacksEmpty();
            }
        });
        dummy.addNormalSlotsForPlayerInventory(8, 84);
        return dummy;
    }

    private boolean checkSlot(ItemStack stack, int slotNumber) {
        if (this.getRecipeForTaget() == null || this.getRecipeForTaget().length <= slotNumber) {
            return true;
        }
        ItemStack allowed = this.getRecipeForTaget()[slotNumber];
        if (allowed == null) {
            return stack == null;
        }
        return stack.field_77993_c == allowed.field_77993_c && stack.func_77960_j() == allowed.func_77960_j();
    }

    public boolean areStacksEmpty() {
        for (int i = 0; i < 9; ++i) {
            if (this.inv.func_70301_a(i) == null || this.inv.func_70301_a((int)i).field_77993_c == 0) continue;
            return false;
        }
        return true;
    }

    public ItemStack[] getRecipeForTaget() {
        return this.getRecipeForTaget(this.inv.func_70301_a(11));
    }

    public ItemStack[] getRecipeForTaget(ItemStack target) {
        if (target == null) {
            return null;
        }
        for (SolderingStationRecipes.SolderingStationRecipe recipe : SolderingStationRecipes.getRecipes()) {
            if (target.field_77993_c != recipe.result.field_77993_c || target.func_77960_j() != recipe.result.func_77960_j()) continue;
            return recipe.source;
        }
        return null;
    }

    public ItemStack getTargetForTaget() {
        return this.getTargetForTaget(this.inv.func_70301_a(11));
    }

    public ItemStack getTargetForTaget(ItemStack target) {
        if (target == null) {
            return null;
        }
        for (SolderingStationRecipes.SolderingStationRecipe recipe : SolderingStationRecipes.getRecipes()) {
            if (target.field_77993_c != recipe.result.field_77993_c || target.func_77960_j() != recipe.result.func_77960_j()) continue;
            return recipe.result;
        }
        return null;
    }

    public List getRecipeForTagetAsItemIdentifierStackList() {
        LinkedList<ItemIdentifierStack> list = new LinkedList<ItemIdentifierStack>();
        ItemStack[] array = this.getRecipeForTaget();
        if (array != null) {
            for (ItemStack stack : array) {
                if (stack != null) {
                    list.addLast(ItemIdentifier.get(stack).makeStack(1));
                    continue;
                }
                list.addLast(null);
            }
        }
        return list;
    }

    private boolean itemEquals(ItemStack var1, ItemStack var2) {
        return var1.field_77993_c == var2.field_77993_c && var1.func_77960_j() == var2.func_77960_j();
    }

    public ItemStack getTagetForRecipe(boolean remove) {
        for (SolderingStationRecipes.SolderingStationRecipe recipe : SolderingStationRecipes.getRecipes()) {
            boolean match = true;
            boolean removeThis = false;
            for (int i = 0; i < 9; ++i) {
                ItemStack recipestack = recipe.source[i];
                ItemStack inputStack = this.inv.func_70301_a(i);
                if (recipestack == null) {
                    if (inputStack == null) continue;
                    match = false;
                    continue;
                }
                if (inputStack == null) {
                    match = false;
                    continue;
                }
                if (!this.itemEquals(recipestack, inputStack)) {
                    match = false;
                    continue;
                }
                if (!remove || (this.getTagetForRecipe(false) == null || !this.itemEquals(this.getTagetForRecipe(false), recipe.result)) && !removeThis) continue;
                --inputStack.field_77994_a;
                if (inputStack.field_77994_a <= 0) {
                    inputStack = null;
                }
                this.inv.func_70299_a(i, inputStack);
                removeThis = true;
            }
            if (!match) continue;
            return recipe.result.func_77946_l();
        }
        return null;
    }

    public ICraftingResultHandler getHandlerForRecipe() {
        for (SolderingStationRecipes.SolderingStationRecipe recipe : SolderingStationRecipes.getRecipes()) {
            boolean match = true;
            for (int i = 0; i < 9; ++i) {
                ItemStack recipestack = recipe.source[i];
                ItemStack inputStack = this.inv.func_70301_a(i);
                if (recipestack == null) {
                    if (inputStack == null) continue;
                    match = false;
                    continue;
                }
                if (inputStack == null) {
                    match = false;
                    continue;
                }
                if (this.itemEquals(recipestack, inputStack)) continue;
                match = false;
            }
            if (!match) continue;
            return recipe.handler;
        }
        return null;
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.inv.readFromNBT(nbt, "");
        this.rotation = nbt.func_74762_e("rotation");
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        this.inv.writeToNBT(nbt, "");
        nbt.func_74768_a("rotation", this.rotation);
    }

    private boolean hasWork() {
        return this.getTagetForRecipe(false) != null && this.inv.func_70301_a(9) != null;
    }

    private void updateHeat() {
        MainProxy.sendPacketToAllWatchingChunk(this.field_70329_l, this.field_70327_n, MainProxy.getDimensionForWorld(this.field_70331_k), ((SolderingStationHeat)PacketHandler.getPacket(SolderingStationHeat.class)).setInteger(this.heat).setPosX(this.field_70329_l).setPosY(this.field_70330_m).setPosZ(this.field_70327_n));
        MainProxy.sendToPlayerList(((SolderingStationHeat)PacketHandler.getPacket(SolderingStationHeat.class)).setInteger(this.heat).setPosX(this.field_70329_l).setPosY(this.field_70330_m).setPosZ(this.field_70327_n), this.listener);
    }

    private void updateProgress() {
        MainProxy.sendToPlayerList(((SolderingStationProgress)PacketHandler.getPacket(SolderingStationProgress.class)).setInteger(this.progress).setPosX(this.field_70329_l).setPosY(this.field_70330_m).setPosZ(this.field_70327_n), this.listener);
    }

    private void updateInventory() {
        MainProxy.sendToPlayerList(((SolderingStationInventory)PacketHandler.getPacket(SolderingStationInventory.class)).setInventory((IInventory)this).setPosX(this.field_70329_l).setPosY(this.field_70330_m).setPosZ(this.field_70327_n), this.listener);
    }

    public void func_70316_g() {
        if (MainProxy.isClient(this.field_70331_k)) {
            if (!this.init) {
                MainProxy.sendPacketToServer(((RequestRotationPacket)PacketHandler.getPacket(RequestRotationPacket.class)).setPosX(this.field_70329_l).setPosY(this.field_70330_m).setPosZ(this.field_70327_n));
                this.init = true;
            }
            return;
        }
        this.hasWork = this.hasWork();
        if (this.hasWork && this.heat < 100) {
            if (this.provider.useEnergy(1.0f, 100.0f, false) >= 1.0f) {
                this.heat = (int)((float)this.heat + this.provider.useEnergy(1.0f, 100.0f, true));
                if (this.heat > 100) {
                    this.heat = 100;
                }
                this.updateHeat();
            } else if (this.field_70331_k.func_72820_D() % 5L == 0L) {
                --this.heat;
                if (this.heat < 0) {
                    this.heat = 0;
                }
                this.updateHeat();
            }
        } else if (!this.hasWork && this.heat > 0) {
            --this.heat;
            this.updateHeat();
        }
        if (this.hasWork && this.heat >= 100) {
            this.progress = (int)((float)this.progress + this.provider.useEnergy(1.0f, 3.0f, true));
            if (this.progress >= 100) {
                this.progress = this.tryCraft() ? 0 : (this.progress -= 50);
            }
            this.updateProgress();
        } else if (!this.hasWork && this.progress != 0) {
            this.progress = 0;
            this.updateProgress();
        }
    }

    private boolean tryCraft() {
        ItemStack content = this.inv.func_70301_a(10);
        ICraftingResultHandler handler = this.getHandlerForRecipe();
        ItemStack toAdd = this.getTagetForRecipe(false);
        if (handler != null) {
            handler.handleCrafting(toAdd);
        }
        if (content != null) {
            if (!content.func_77969_a(toAdd) || !ItemStack.func_77970_a((ItemStack)content, (ItemStack)toAdd)) {
                return false;
            }
            if (content.field_77994_a + toAdd.field_77994_a > content.func_77976_d()) {
                return false;
            }
            toAdd.field_77994_a += content.field_77994_a;
        }
        content = this.getTagetForRecipe(true);
        this.inv.func_70299_a(10, toAdd);
        --this.inv.func_70301_a((int)9).field_77994_a;
        if (this.inv.func_70301_a((int)9).field_77994_a <= 0) {
            this.inv.func_70299_a(9, null);
        }
        this.inv.func_70296_d();
        super.func_70296_d();
        this.updateInventory();
        return true;
    }

    public void setPowerProvider(IPowerProvider provider) {
        this.provider = provider;
    }

    public IPowerProvider getPowerProvider() {
        return this.provider;
    }

    public void doWork() {
    }

    public int powerRequest(ForgeDirection from) {
        if (this.hasWork()) {
            return this.provider.getMaxEnergyReceived();
        }
        return 0;
    }

    public int func_70302_i_() {
        return this.inv.func_70302_i_();
    }

    public ItemStack func_70301_a(int var1) {
        return this.inv.func_70301_a(var1);
    }

    public ItemStack func_70298_a(int var1, int var2) {
        return this.inv.func_70298_a(var1, var2);
    }

    public ItemStack func_70304_b(int var1) {
        return this.inv.func_70304_b(var1);
    }

    public void func_70299_a(int var1, ItemStack var2) {
        this.inv.func_70299_a(var1, var2);
    }

    public String func_70303_b() {
        return this.inv.func_70303_b();
    }

    public int func_70297_j_() {
        return this.inv.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.inv.func_70300_a(var1);
    }

    public void func_70295_k_() {
        this.inv.func_70295_k_();
    }

    public void func_70305_f() {
        this.inv.func_70305_f();
    }

    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        if (stack == null) {
            return 0;
        }
        if (stack.func_77973_b() == null) {
            return 0;
        }
        if (stack.func_77973_b() == Item.field_77703_o) {
            ItemStack iron = this.inv.func_70301_a(9);
            if (iron == null) {
                iron = new ItemStack(Item.field_77703_o, 0, 0);
                this.inv.func_70299_a(9, iron);
            }
            int freespace = 64 - iron.field_77994_a;
            int toAdd = Math.min(stack.field_77994_a, freespace);
            if (doAdd) {
                iron.field_77994_a += toAdd;
                this.inv.func_70296_d();
                super.func_70296_d();
            }
            if (iron.field_77994_a == 0) {
                this.inv.func_70299_a(9, null);
            }
            return toAdd;
        }
        ItemStack[] recipe = this.getRecipeForTaget();
        if (recipe == null) {
            return 0;
        }
        int availableslots = 0;
        int itemsinslots = 0;
        int i = 0;
        for (ItemStack itemstack : recipe) {
            if (itemstack == null) {
                ++i;
                continue;
            }
            if (stack.field_77993_c == itemstack.field_77993_c && stack.func_77960_j() == itemstack.func_77960_j()) {
                ++availableslots;
                ItemStack slot = this.inv.func_70301_a(i);
                if (slot != null) {
                    itemsinslots += slot.field_77994_a;
                }
            }
            ++i;
        }
        int toadd = Math.min(availableslots * 64 - itemsinslots, stack.field_77994_a);
        if (!doAdd) {
            return toadd;
        }
        if (toadd <= 0) {
            return 0;
        }
        int itemsperslot = (itemsinslots += toadd) / availableslots;
        int itemsextra = itemsinslots - itemsperslot * availableslots;
        i = 0;
        for (ItemStack itemstack : recipe) {
            if (itemstack == null) {
                ++i;
                continue;
            }
            if (stack.field_77993_c == itemstack.field_77993_c && stack.func_77960_j() == itemstack.func_77960_j()) {
                if (itemsperslot == 0 && itemsextra == 0) {
                    this.inv.func_70299_a(i, null);
                } else {
                    ItemStack slot = this.inv.func_70301_a(i);
                    if (slot == null) {
                        slot = stack.func_77946_l();
                    }
                    slot.field_77994_a = itemsperslot;
                    if (itemsextra > 0) {
                        ++slot.field_77994_a;
                        --itemsextra;
                    }
                    this.inv.func_70299_a(i, slot);
                }
            }
            ++i;
        }
        this.inv.func_70296_d();
        super.func_70296_d();
        return toadd;
    }

    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        ItemStack[] tmp = new ItemStack[]{this.inv.func_70301_a(10)};
        if (doRemove) {
            this.inv.func_70299_a(10, null);
            this.inv.func_70296_d();
            super.func_70296_d();
        }
        return tmp;
    }

    @Override
    public void guiOpenedByPlayer(EntityPlayer player) {
        this.listener.add(player);
    }

    @Override
    public void guiClosedByPlayer(EntityPlayer player) {
        this.listener.remove(player);
    }

    public void onBlockBreak() {
        this.inv.dropContents(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public int getRotation() {
        return this.rotation;
    }

    @Override
    public int getFrontTexture() {
        if (this.heat > 0) {
            return 3;
        }
        return 8;
    }

    @Override
    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public boolean func_94042_c() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public void func_85027_a(CrashReportCategory par1CrashReportCategory) {
        super.func_85027_a(par1CrashReportCategory);
        par1CrashReportCategory.func_71507_a("LP-Version", (Object)"0.7.3.ftb.631:false");
    }
}

