/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.asm;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.IClassTransformer;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.List;
import logisticspipes.LogisticsPipes;
import logisticspipes.asm.LogisticsASMHelperClass;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class LogisticsClassTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] bytes) {
        try {
            if (name.equals("buildcraft.transport.PipeTransportItems")) {
                return this.handlePipeTransportItems(bytes);
            }
            if (!name.startsWith("logisticspipes.")) {
                return bytes;
            }
            if (name.equals("logisticspipes.asm.LogisticsASMHelperClass")) {
                return bytes;
            }
            return this.handleLPTransformation(bytes);
        }
        catch (Exception e) {
            if (LogisticsPipes.DEBUG) {
                e.printStackTrace();
                return bytes;
            }
            throw new RuntimeException(e);
        }
    }

    private byte[] handlePipeTransportItems(byte[] bytes) {
        ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(bytes);
        reader.accept((ClassVisitor)node, 0);
        boolean handled = false;
        for (MethodNode m : node.methods) {
            if (!m.name.equals("canReceivePipeObjects")) continue;
            LocalMethodVisitor newM = new LocalMethodVisitor(m.access, m.name, m.desc, m.signature, m.exceptions.toArray(new String[0])){

                @Override
                protected void addCode(MethodNode node) {
                    LogisticsASMHelperClass.visitCanRecivePipeObject((MethodVisitor)node);
                }
            };
            m.accept((MethodVisitor)newM);
            node.methods.set(node.methods.indexOf(m), newM);
            handled = true;
            break;
        }
        if (!handled) {
            throw new RuntimeException("Method 'canReceivePipeObjects' from 'buildcraft.transport.PipeTransportItems' could not be found.");
        }
        ClassWriter writer = new ClassWriter(3);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] handleLPTransformation(byte[] bytes) {
        ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(bytes);
        reader.accept((ClassVisitor)node, 0);
        boolean changed = false;
        if (node.visibleAnnotations != null) {
            for (AnnotationNode a : node.visibleAnnotations) {
                if (!a.desc.equals("Llogisticspipes/asm/ModDependentInterface;")) continue;
                if (a.values.size() == 4 && a.values.get(0).equals("modId") && a.values.get(2).equals("interfacePath")) {
                    List modId = (List)a.values.get(1);
                    List interfacePath = (List)a.values.get(3);
                    if (modId.size() != interfacePath.size()) {
                        throw new RuntimeException("The Arrays have to be of the same size.");
                    }
                    block1: for (int i = 0; i < modId.size(); ++i) {
                        if (Loader.isModLoaded((String)((String)modId.get(i)))) continue;
                        for (String inter : node.interfaces) {
                            if (!inter.replace("/", ".").equals(interfacePath.get(i))) continue;
                            node.interfaces.remove(inter);
                            changed = true;
                            continue block1;
                        }
                    }
                    continue;
                }
                throw new UnsupportedOperationException("Can't parse the annotations correctly");
            }
        }
        ArrayList<MethodNode> methodsToRemove = new ArrayList<MethodNode>();
        block3: for (MethodNode m : node.methods) {
            if (m.visibleAnnotations == null) continue;
            for (AnnotationNode a : m.visibleAnnotations) {
                if (a.desc.equals("Llogisticspipes/asm/ModDependentMethod;")) {
                    if (a.values.size() == 2 && a.values.get(0).equals("modId")) {
                        String modId = a.values.get(1).toString();
                        if (Loader.isModLoaded((String)modId)) continue;
                        methodsToRemove.add(m);
                        continue block3;
                    }
                    throw new UnsupportedOperationException("Can't parse the annotation correctly");
                }
                if (!a.desc.equals("Llogisticspipes/asm/ClientSideOnlyMethodContent;") || !FMLCommonHandler.instance().getSide().equals((Object)Side.SERVER)) continue;
                m.instructions.clear();
                m.localVariables.clear();
                m.tryCatchBlocks.clear();
                m.visitCode();
                Label l0 = new Label();
                m.visitLabel(l0);
                m.visitMethodInsn(184, "logisticspipes/asm/LogisitcsASMHookClass", "callingClearedMethod", "()V");
                Label l1 = new Label();
                m.visitLabel(l1);
                m.visitInsn(177);
                Label l2 = new Label();
                m.visitLabel(l2);
                m.visitLocalVariable("this", "Llogisticspipes/network/packets/DummyPacket;", null, l0, l2, 0);
                m.visitLocalVariable("player", "Lnet/minecraft/entity/player/EntityPlayer;", null, l0, l2, 1);
                m.visitMaxs(0, 2);
                m.visitEnd();
                changed = true;
                continue block3;
            }
        }
        for (MethodNode m : methodsToRemove) {
            node.methods.remove(m);
        }
        ArrayList<FieldNode> fieldsToRemove = new ArrayList<FieldNode>();
        block6: for (FieldNode f : node.fields) {
            if (f.visibleAnnotations == null) continue;
            for (AnnotationNode a : f.visibleAnnotations) {
                if (!a.desc.equals("Llogisticspipes/asm/ModDependentField;")) continue;
                if (a.values.size() == 2 && a.values.get(0).equals("modId")) {
                    String modId = a.values.get(1).toString();
                    if (Loader.isModLoaded((String)modId)) continue;
                    fieldsToRemove.add(f);
                    continue block6;
                }
                throw new UnsupportedOperationException("Can't parse the annotation correctly");
            }
        }
        for (FieldNode f : fieldsToRemove) {
            node.fields.remove(f);
        }
        if (!changed && methodsToRemove.isEmpty() && fieldsToRemove.isEmpty()) {
            return bytes;
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private abstract class LocalMethodVisitor
    extends MethodNode {
        public LocalMethodVisitor(int access, String name, String desc, String signature, String[] exceptions) {
            super(access, name, desc, signature, exceptions);
        }

        public void visitCode() {
            super.visitCode();
            this.addCode(this);
        }

        protected abstract void addCode(MethodNode var1);
    }
}

