/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes;

import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLFingerprintViolationEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.FMLInjectionData;
import cpw.mods.fml.relauncher.RelaunchClassLoader;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import logisticspipes.blocks.LogisticsSignBlock;
import logisticspipes.blocks.LogisticsSolidBlock;
import logisticspipes.commands.LogisticsPipesCommand;
import logisticspipes.config.Configs;
import logisticspipes.items.CraftingSignCreator;
import logisticspipes.items.ItemDisk;
import logisticspipes.items.ItemHUDArmor;
import logisticspipes.items.ItemModule;
import logisticspipes.items.ItemParts;
import logisticspipes.items.ItemUpgrade;
import logisticspipes.items.LogisticsBrokenItem;
import logisticspipes.items.LogisticsItem;
import logisticspipes.items.LogisticsItemCard;
import logisticspipes.items.LogisticsLiquidContainer;
import logisticspipes.items.LogisticsNetworkManager;
import logisticspipes.items.LogisticsSolidBlockItem;
import logisticspipes.items.RemoteOrderer;
import logisticspipes.log.RequestLogFormator;
import logisticspipes.logic.BaseLogicLiquidSatellite;
import logisticspipes.logic.BaseLogicSatellite;
import logisticspipes.logistics.LogisticsLiquidManager;
import logisticspipes.logistics.LogisticsManagerV2;
import logisticspipes.main.CreativeTabLP;
import logisticspipes.main.LogisticsEventListener;
import logisticspipes.network.GuiHandler;
import logisticspipes.network.PacketHandler;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.ProxyManager;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.SpecialInventoryHandlerManager;
import logisticspipes.proxy.buildcraft.BuildCraftProxy;
import logisticspipes.proxy.recipeproviders.AssemblyAdvancedWorkbench;
import logisticspipes.proxy.recipeproviders.AssemblyTable;
import logisticspipes.proxy.recipeproviders.AutoWorkbench;
import logisticspipes.proxy.recipeproviders.ImmibisCraftingTableMk2;
import logisticspipes.proxy.recipeproviders.LogisticsCraftingTable;
import logisticspipes.proxy.recipeproviders.RollingMachine;
import logisticspipes.proxy.recipeproviders.SolderingStation;
import logisticspipes.proxy.specialconnection.SpecialPipeConnection;
import logisticspipes.proxy.specialconnection.SpecialTileConnection;
import logisticspipes.proxy.specialconnection.TeleportPipes;
import logisticspipes.proxy.specialconnection.TesseractConnection;
import logisticspipes.proxy.specialtankhandler.BuildCraftTankHandler;
import logisticspipes.proxy.specialtankhandler.SpecialTankHandler;
import logisticspipes.recipes.RecipeManager;
import logisticspipes.recipes.SolderingStationRecipes;
import logisticspipes.renderer.LiquidContainerRenderer;
import logisticspipes.renderer.LogisticsHUDRenderer;
import logisticspipes.routing.RouterManager;
import logisticspipes.routing.ServerRouter;
import logisticspipes.textures.Textures;
import logisticspipes.ticks.ClientPacketBufferHandlerThread;
import logisticspipes.ticks.DebugGuiTickHandler;
import logisticspipes.ticks.HudUpdateTick;
import logisticspipes.ticks.QueuedTasks;
import logisticspipes.ticks.RenderTickHandler;
import logisticspipes.ticks.RoutingTableUpdateThread;
import logisticspipes.ticks.ServerPacketBufferHandlerThread;
import logisticspipes.ticks.VersionChecker;
import logisticspipes.ticks.Watchdog;
import logisticspipes.ticks.WorldTickHandler;
import logisticspipes.utils.InventoryUtilFactory;
import logisticspipes.utils.LiquidIdentifier;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="LogisticsPipes|Main", name="Logistics Pipes", version="0.7.3.ftb.631", certificateFingerprint="e896b0959225b49ad1c1c512ab870ccedabec74b", dependencies="required-after:Forge@[6.5.0.0,);required-after:BuildCraft|Core;required-after:BuildCraft|Transport;required-after:BuildCraft|Builders;required-after:BuildCraft|Silicon;after:IC2;after:Forestry;after:Thaumcraft;after:CCTurtle;after:ComputerCraft;after:factorization;after:GregTech_Addon;after:AppliedEnergistics;after:ThermalExpansion;after:BetterStorage")
@NetworkMod(channels={"BCLP"}, packetHandler=PacketHandler.class, clientSideRequired=true)
public class LogisticsPipes {
    @Mod.Instance(value="LogisticsPipes|Main")
    public static LogisticsPipes instance;
    public static final String LOGISTICS_PIPES_CHANNEL_NAME = "BCLP";
    public static boolean DisplayRequests;
    public static final boolean DEBUG;
    public static final String MCVersion = "1.5.2";
    public static final String VERSION = "0.7.3.ftb.631:false";
    public static final boolean DEV_BUILD;
    public static boolean WATCHDOG;
    private boolean certificateError = false;
    public static Item LogisticsBasicPipe;
    public static Item LogisticsRequestPipeMk1;
    public static Item LogisticsRequestPipeMk2;
    public static Item LogisticsProviderPipeMk1;
    public static Item LogisticsProviderPipeMk2;
    public static Item LogisticsCraftingPipeMk1;
    public static Item LogisticsCraftingPipeMk2;
    public static Item LogisticsCraftingPipeMk3;
    public static Item LogisticsSatellitePipe;
    public static Item LogisticsSupplierPipe;
    public static Item LogisticsChassisPipeMk1;
    public static Item LogisticsChassisPipeMk2;
    public static Item LogisticsChassisPipeMk3;
    public static Item LogisticsChassisPipeMk4;
    public static Item LogisticsChassisPipeMk5;
    public static Item LogisticsRemoteOrdererPipe;
    public static Item LogisticsInvSysConPipe;
    public static Item LogisticsEntrancePipe;
    public static Item LogisticsDestinationPipe;
    public static Item LogisticsFirewallPipe;
    public static Item logisticsRequestTable;
    public static Item LogisticsApiaristAnalyzerPipe;
    public static Item LogisticsApiaristSinkPipe;
    public static Item LogisticsLiquidBasicPipe;
    public static Item LogisticsLiquidRequestPipe;
    public static Item LogisticsLiquidProviderPipe;
    public static Item LogisticsLiquidSatellitePipe;
    public static Item LogisticsLiquidSupplierPipeMk1;
    public static Item LogisticsLiquidSupplierPipeMk2;
    public static Item LogisticsLiquidConnectorPipe;
    public static Item LogisticsLiquidInsertionPipe;
    public static Item LogisticsLiquidExtractorPipe;
    public static ItemModule ModuleItem;
    public static ItemUpgrade UpgradeItem;
    public static Item LogisticsNetworkMonitior;
    public static Item LogisticsRemoteOrderer;
    public static Item LogisticsCraftingSignCreator;
    public static ItemDisk LogisticsItemDisk;
    public static Item LogisticsItemCard;
    public static ItemHUDArmor LogisticsHUDArmor;
    public static Item LogisticsParts;
    public static Item LogisticsUpgradeManager;
    public static Item LogisticsLiquidContainer;
    public static Item LogisticsBrokenItem;
    public static Block LogisticsSign;
    public static Block LogisticsSolidBlock;
    public static Textures textures;
    public static final String logisticsTileGenericPipeMapping = "logisticspipes.pipes.basic.LogisticsTileGenericPipe";
    public static CreativeTabLP LPCreativeTab;
    public static Logger log;
    public static Logger requestLog;

    public LogisticsPipes() {
        RelaunchClassLoader loader = (RelaunchClassLoader)LogisticsPipes.class.getClassLoader();
        loader.registerTransformer("logisticspipes.asm.LogisticsClassTransformer");
        PacketHandler.intialize();
    }

    @Mod.Init
    public void init(FMLInitializationEvent event) {
        RouterManager manager = new RouterManager();
        SimpleServiceLocator.setRouterManager(manager);
        SimpleServiceLocator.setDirectConnectionManager(manager);
        SimpleServiceLocator.setSecurityStationManager(manager);
        SimpleServiceLocator.setLogisticsManager(new LogisticsManagerV2());
        SimpleServiceLocator.setInventoryUtilFactory(new InventoryUtilFactory());
        SimpleServiceLocator.setSpecialConnectionHandler(new SpecialPipeConnection());
        SimpleServiceLocator.setSpecialConnectionHandler(new SpecialTileConnection());
        SimpleServiceLocator.setLogisticsLiquidManager(new LogisticsLiquidManager());
        SimpleServiceLocator.setSpecialTankHandler(new SpecialTankHandler());
        if (event.getSide().isClient()) {
            SimpleServiceLocator.buildCraftProxy.registerLocalization();
        }
        NetworkRegistry.instance().registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        if (event.getSide().equals((Object)Side.CLIENT)) {
            TickRegistry.registerTickHandler((ITickHandler)new RenderTickHandler(), (Side)Side.CLIENT);
        }
        if (!Configs.LOGISTICS_TILE_GENERIC_PIPE_REPLACEMENT_DISABLED) {
            TickRegistry.registerTickHandler((ITickHandler)new WorldTickHandler(), (Side)Side.SERVER);
            TickRegistry.registerTickHandler((ITickHandler)new WorldTickHandler(), (Side)Side.CLIENT);
        }
        TickRegistry.registerTickHandler((ITickHandler)new QueuedTasks(), (Side)Side.SERVER);
        if (event.getSide() == Side.CLIENT) {
            SimpleServiceLocator.setClientPacketBufferHandlerThread(new ClientPacketBufferHandlerThread());
        }
        SimpleServiceLocator.setServerPacketBufferHandlerThread(new ServerPacketBufferHandlerThread());
        for (int i = 0; i < Configs.MULTI_THREAD_NUMBER; ++i) {
            new RoutingTableUpdateThread(i);
        }
        LogisticsEventListener eventListener = new LogisticsEventListener();
        MinecraftForge.EVENT_BUS.register((Object)eventListener);
        GameRegistry.registerPlayerTracker((IPlayerTracker)eventListener);
        textures.registerBlockIcons();
        SimpleServiceLocator.buildCraftProxy.initProxyAndCheckVersion();
        if (event.getSide().equals((Object)Side.CLIENT)) {
            TickRegistry.registerTickHandler((ITickHandler)DebugGuiTickHandler.instance(), (Side)Side.CLIENT);
        }
        TickRegistry.registerTickHandler((ITickHandler)DebugGuiTickHandler.instance(), (Side)Side.SERVER);
    }

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent evt) {
        Configs.load(evt);
        log = evt.getModLog();
        requestLog = Logger.getLogger("LogisticsPipes|Request");
        requestLog.setUseParentHandlers(false);
        try {
            File logPath = new File((File)FMLInjectionData.data()[6], "LogisticsPipes-Request.log");
            FileHandler fileHandler = new FileHandler(logPath.getPath(), true);
            fileHandler.setFormatter(new RequestLogFormator());
            fileHandler.setLevel(Level.ALL);
            requestLog.addHandler(fileHandler);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (DEBUG) {
            log.setLevel(Level.ALL);
        }
        if (this.certificateError) {
            log.severe("Certificate not correct");
            log.severe("This in not a LogisticsPipes version from RS485.");
        }
        if (DEV_BUILD) {
            log.fine("You are using a dev version.");
            log.fine("While the dev versions contain cutting edge features, they may also contain more bugs.");
            log.fine("Please report any you find to https://github.com/RS485/LogisticsPipes-Dev/issues");
        }
        SimpleServiceLocator.setBuildCraftProxy(new BuildCraftProxy());
        SimpleServiceLocator.buildCraftProxy.replaceBlockGenericPipe();
    }

    @Mod.PostInit
    public void postInit(FMLPostInitializationEvent event) {
        boolean isClient = event.getSide() == Side.CLIENT;
        ProxyManager.load();
        SpecialInventoryHandlerManager.load();
        SimpleServiceLocator.specialpipeconnection.registerHandler(new TeleportPipes());
        SimpleServiceLocator.specialtileconnection.registerHandler(new TesseractConnection());
        SimpleServiceLocator.specialTankHandler.registerHandler(new BuildCraftTankHandler());
        LiquidContainerRenderer renderer = null;
        if (isClient) {
            renderer = new LiquidContainerRenderer();
        }
        LogisticsNetworkMonitior = new LogisticsNetworkManager(Configs.LOGISTICSNETWORKMONITOR_ID);
        LogisticsNetworkMonitior.func_77655_b("networkMonitorItem");
        LogisticsItemCard = new LogisticsItemCard(Configs.ITEM_CARD_ID);
        LogisticsItemCard.func_77655_b("logisticsItemCard");
        if (isClient) {
            MinecraftForgeClient.registerItemRenderer((int)LogisticsPipes.LogisticsItemCard.field_77779_bT, (IItemRenderer)renderer);
        }
        LogisticsRemoteOrderer = new RemoteOrderer(Configs.LOGISTICSREMOTEORDERER_ID);
        LogisticsRemoteOrderer.func_77655_b("remoteOrdererItem");
        LogisticsCraftingSignCreator = new CraftingSignCreator(Configs.LOGISTICSCRAFTINGSIGNCREATOR_ID);
        LogisticsCraftingSignCreator.func_77655_b("CraftingSignCreator");
        int renderIndex = isClient ? RenderingRegistry.addNewArmourRendererPrefix((String)"LogisticsHUD") : 0;
        LogisticsHUDArmor = new ItemHUDArmor(Configs.ITEM_HUD_ID, renderIndex);
        LogisticsHUDArmor.func_77655_b("logisticsHUDGlasses");
        LogisticsParts = new ItemParts(Configs.ITEM_PARTS_ID);
        LogisticsParts.func_77655_b("logisticsParts");
        SimpleServiceLocator.buildCraftProxy.registerTrigger();
        ModuleItem = new ItemModule(Configs.ITEM_MODULE_ID);
        ModuleItem.func_77655_b("itemModule");
        ModuleItem.loadModules();
        LogisticsItemDisk = new ItemDisk(Configs.ITEM_DISK_ID);
        LogisticsItemDisk.func_77655_b("itemDisk");
        UpgradeItem = new ItemUpgrade(Configs.ITEM_UPGRADE_ID);
        UpgradeItem.func_77655_b("itemUpgrade");
        UpgradeItem.loadUpgrades();
        LogisticsUpgradeManager = new LogisticsItem(Configs.ITEM_UPGRADE_MANAGER_ID);
        LogisticsUpgradeManager.func_77655_b("upgradeManagerItem");
        LogisticsLiquidContainer = new LogisticsLiquidContainer(Configs.ITEM_LIQUID_CONTAINER_ID);
        LogisticsLiquidContainer.func_77655_b("logisticsLiquidContainer");
        if (isClient) {
            MinecraftForgeClient.registerItemRenderer((int)LogisticsPipes.LogisticsLiquidContainer.field_77779_bT, (IItemRenderer)renderer);
        }
        LogisticsBrokenItem = new LogisticsBrokenItem(Configs.ITEM_BROKEN_ID);
        LogisticsBrokenItem.func_77655_b("brokenItem");
        SimpleServiceLocator.buildCraftProxy.registerPipes(event.getSide());
        LanguageRegistry.instance().addNameForObject((Object)LogisticsNetworkMonitior, "en_US", "Network monitor");
        LanguageRegistry.instance().addNameForObject((Object)LogisticsItemCard, "en_US", "Logistics Item Card");
        LanguageRegistry.instance().addNameForObject((Object)LogisticsRemoteOrderer, "en_US", "Remote Orderer");
        LanguageRegistry.instance().addNameForObject((Object)LogisticsCraftingSignCreator, "en_US", "Crafting Sign Creator");
        LanguageRegistry.instance().addNameForObject((Object)ModuleItem, "en_US", "BlankModule");
        LanguageRegistry.instance().addNameForObject((Object)LogisticsItemDisk, "en_US", "Logistics Disk");
        LanguageRegistry.instance().addNameForObject((Object)LogisticsHUDArmor, "en_US", "Logistics HUD Glasses");
        LanguageRegistry.instance().addNameForObject((Object)new ItemStack(LogisticsParts, 1, 0), "en_US", "Logistics HUD Bow");
        LanguageRegistry.instance().addNameForObject((Object)new ItemStack(LogisticsParts, 1, 1), "en_US", "Logistics HUD Glass");
        LanguageRegistry.instance().addNameForObject((Object)new ItemStack(LogisticsParts, 1, 2), "en_US", "Logistics HUD Nose Bridge");
        LanguageRegistry.instance().addNameForObject((Object)new ItemStack(LogisticsParts, 1, 3), "en_US", "Nano Hopper");
        LanguageRegistry.instance().addNameForObject((Object)new ItemStack(LogisticsUpgradeManager, 1, 0), "en_US", "Upgrade Manager");
        LanguageRegistry.instance().addNameForObject((Object)new ItemStack(LogisticsBrokenItem, 1, 0), "en_US", "Logistics Broken Item");
        LanguageRegistry.instance().addNameForObject((Object)new ItemStack(LogisticsLiquidContainer, 1, 0), "en_US", "Logistics Liquid Container");
        LanguageRegistry.instance().addStringLocalization("itemGroup.Logistics_Pipes", "en_US", "Logistics Pipes");
        SimpleServiceLocator.IC2Proxy.addCraftingRecipes();
        SimpleServiceLocator.forestryProxy.addCraftingRecipes();
        SimpleServiceLocator.thaumCraftProxy.addCraftingRecipes();
        SimpleServiceLocator.addCraftingRecipeProvider(new AutoWorkbench());
        SimpleServiceLocator.addCraftingRecipeProvider(new AssemblyAdvancedWorkbench());
        SimpleServiceLocator.addCraftingRecipeProvider(new AssemblyTable());
        SimpleServiceLocator.addCraftingRecipeProvider(new SolderingStation());
        SimpleServiceLocator.addCraftingRecipeProvider(new LogisticsCraftingTable());
        if (RollingMachine.load()) {
            SimpleServiceLocator.addCraftingRecipeProvider(new RollingMachine());
        }
        if (ImmibisCraftingTableMk2.load()) {
            SimpleServiceLocator.addCraftingRecipeProvider(new ImmibisCraftingTableMk2());
        }
        SolderingStationRecipes.loadRecipe();
        LogisticsSign = new LogisticsSignBlock(Configs.LOGISTICS_SIGN_ID);
        GameRegistry.registerBlock((Block)LogisticsSign, ItemBlock.class, null);
        LogisticsSign.func_71864_b("logisticsSign");
        LogisticsSolidBlock = new LogisticsSolidBlock(Configs.LOGISTICS_SOLID_BLOCK_ID);
        GameRegistry.registerBlock((Block)LogisticsSolidBlock, LogisticsSolidBlockItem.class, null);
        LogisticsSign.func_71864_b("logisticsSolidBlock");
        MainProxy.proxy.registerTileEntities();
        RecipeManager.loadRecipes();
        MainProxy.proxy.registerParticles();
        LiquidIdentifier.initFromForge(false);
        LiquidIdentifier.get(9, 0, "water");
        LiquidIdentifier.get(11, 0, "lava");
        if (!FMLCommonHandler.instance().getModName().contains("MCPC") && (Configs.WATCHDOG_CLIENT && isClient || Configs.WATCHDOG_SERVER)) {
            new Watchdog(isClient);
            WATCHDOG = true;
        }
        new VersionChecker();
    }

    @Mod.ServerStopping
    public void cleanup(FMLServerStoppingEvent event) {
        SimpleServiceLocator.routerManager.serverStopClean();
        QueuedTasks.clearAllTasks();
        HudUpdateTick.clearUpdateFlags();
        BaseLogicSatellite.cleanup();
        BaseLogicLiquidSatellite.cleanup();
        ServerRouter.cleanup();
        if (event.getSide().equals((Object)Side.CLIENT)) {
            LogisticsHUDRenderer.instance().clear();
        }
    }

    @Mod.ServerStarting
    public void registerCommands(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new LogisticsPipesCommand());
    }

    @Mod.FingerprintWarning
    public void certificateWarning(FMLFingerprintViolationEvent warning) {
        if (!DEBUG) {
            System.out.println("[LogisticsPipes|Certificate] Certificate not correct");
            System.out.println("[LogisticsPipes|Certificate] Expected: " + warning.expectedFingerprint);
            System.out.println("[LogisticsPipes|Certificate] File: " + warning.source.getAbsolutePath());
            System.out.println("[LogisticsPipes|Certificate] This in not a LogisticsPipes version from RS485.");
            this.certificateError = true;
        }
    }

    static {
        DEBUG = "false".equals("%DEBUG%") || "false".equals("true");
        DEV_BUILD = VERSION.contains(".dev.") || DEBUG;
        WATCHDOG = false;
        textures = new Textures();
        LPCreativeTab = new CreativeTabLP();
    }
}

