/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.core.handlers;

import com.pahimar.ee3.core.util.GeneralHelper;
import com.pahimar.ee3.core.util.LogHelper;
import java.util.ArrayList;
import java.util.logging.Level;
import net.minecraft.item.ItemStack;

public class EquivalencyHandler {
    private static final EquivalencyHandler instance = new EquivalencyHandler();
    private static ArrayList equivalencyList = new ArrayList();

    public static EquivalencyHandler instance() {
        return instance;
    }

    public ArrayList getAllLists() {
        return equivalencyList;
    }

    public void addObjects(Object obj1, Object obj2) {
        ItemStack stack1 = GeneralHelper.convertObjectToItemStack(obj1);
        ItemStack stack2 = GeneralHelper.convertObjectToItemStack(obj2);
        ArrayList currentList = new ArrayList();
        Integer stack1Index = this.getIndexInList(stack1);
        Integer stack2Index = this.getIndexInList(stack2);
        if (stack1Index != null && stack2Index != null) {
            return;
        }
        if (stack1Index != null && stack2Index == null) {
            currentList = (ArrayList)equivalencyList.get(stack1Index);
            currentList.add(stack2);
            equivalencyList.set(stack1Index, currentList);
        } else if (stack1Index == null && stack2Index != null) {
            currentList = (ArrayList)equivalencyList.get(stack2Index);
            currentList.add(stack1);
            equivalencyList.set(stack2Index, currentList);
        } else if (stack1Index == null && stack2Index == null) {
            currentList.add(stack1);
            currentList.add(stack2);
            equivalencyList.add(currentList);
        }
    }

    public void addObjects(Object ... objList) {
        if (objList.length < 2) {
            return;
        }
        for (int i = 0; i < objList.length - 1; ++i) {
            this.addObjects(objList[i], objList[i + 1]);
        }
    }

    public Integer getIndexInList(Object obj) {
        ItemStack checkStack = GeneralHelper.convertObjectToItemStack(obj);
        for (int i = 0; i < equivalencyList.size(); ++i) {
            ArrayList currentList = (ArrayList)equivalencyList.get(i);
            for (ItemStack currentStack : currentList) {
                if (!ItemStack.func_77989_b((ItemStack)checkStack, (ItemStack)currentStack)) continue;
                return new Integer(i);
            }
        }
        return null;
    }

    public Integer getIndexInList(int id, int meta) {
        for (int i = 0; i < equivalencyList.size(); ++i) {
            ArrayList currentList = (ArrayList)equivalencyList.get(i);
            for (ItemStack currentStack : currentList) {
                if (id != currentStack.field_77993_c || meta != currentStack.func_77960_j()) continue;
                return new Integer(i);
            }
        }
        return null;
    }

    public ArrayList getEquivalencyList(Object obj) {
        ItemStack checkStack = GeneralHelper.convertObjectToItemStack(obj);
        if (checkStack == null) {
            return null;
        }
        for (ArrayList list : equivalencyList) {
            for (ItemStack currentStack : list) {
                if (!ItemStack.func_77989_b((ItemStack)checkStack, (ItemStack)currentStack)) continue;
                return list;
            }
        }
        return null;
    }

    public ArrayList getEquivalencyList(int id, int meta) {
        for (ArrayList list : equivalencyList) {
            for (ItemStack currentStack : list) {
                if (id != currentStack.field_77993_c || meta != currentStack.func_77960_j()) continue;
                return list;
            }
        }
        return null;
    }

    public ItemStack getNextInList(Object obj) {
        ItemStack checkStack = GeneralHelper.convertObjectToItemStack(obj);
        if (checkStack != null) {
            return this.getNextInList(checkStack.field_77993_c, checkStack.func_77960_j());
        }
        return null;
    }

    public ItemStack getNextInList(int id, int meta) {
        ArrayList list = this.getEquivalencyList(id, meta);
        ItemStack returnStack = null;
        if (list != null) {
            int i;
            if (list.size() == 1) {
                return (ItemStack)list.get(i);
            }
            for (i = 0; i < list.size(); ++i) {
                ItemStack currentStack = (ItemStack)list.get(i);
                if (id != currentStack.field_77993_c || meta != currentStack.func_77960_j()) continue;
                returnStack = (ItemStack)list.get((i + 1) % list.size());
                break;
            }
        }
        return returnStack;
    }

    public ItemStack getPrevInList(Object obj) {
        ItemStack checkStack = GeneralHelper.convertObjectToItemStack(obj);
        if (checkStack != null) {
            return this.getPrevInList(checkStack.field_77993_c, checkStack.func_77960_j());
        }
        return null;
    }

    public ItemStack getPrevInList(int id, int meta) {
        ArrayList list = this.getEquivalencyList(id, meta);
        ItemStack returnStack = null;
        if (list != null) {
            int i;
            if (list.size() == 1) {
                return (ItemStack)list.get(i);
            }
            for (i = 0; i < list.size(); ++i) {
                ItemStack currentStack = (ItemStack)list.get(i);
                if (id != currentStack.field_77993_c || meta != currentStack.func_77960_j()) continue;
                int index = (i - 1 + list.size()) % list.size();
                returnStack = (ItemStack)list.get(index);
                break;
            }
        }
        return returnStack;
    }

    public boolean areEquivalent(Object obj1, Object obj2) {
        if (this.getEquivalencyList(obj1) != null && this.getEquivalencyList(obj2) != null) {
            if (GeneralHelper.convertObjectToItemStack((Object)obj1).field_77993_c == GeneralHelper.convertObjectToItemStack((Object)obj2).field_77993_c && GeneralHelper.convertObjectToItemStack(obj1).func_77960_j() == GeneralHelper.convertObjectToItemStack(obj2).func_77960_j()) {
                return true;
            }
            return this.getEquivalencyList(obj1).equals(this.getEquivalencyList(obj2));
        }
        return false;
    }

    public boolean areWorldEquivalent(Object obj1, Object obj2) {
        ItemStack first = GeneralHelper.convertObjectToItemStack(obj1);
        if (first == null) {
            return false;
        }
        ItemStack second = GeneralHelper.convertObjectToItemStack(obj2);
        if (second == null) {
            return false;
        }
        if (this.getEquivalencyList(first.field_77993_c, first.func_77960_j()) != null && this.getEquivalencyList(second.field_77993_c, second.func_77960_j()) != null) {
            if (first.field_77993_c == second.field_77993_c && first.func_77960_j() == second.func_77960_j()) {
                return true;
            }
            return this.getEquivalencyList(first.field_77993_c, first.func_77960_j()).equals(this.getEquivalencyList(second.field_77993_c, second.func_77960_j()));
        }
        return false;
    }

    public void debug() {
        int i = 0;
        for (ArrayList list : equivalencyList) {
            LogHelper.log(Level.INFO, "equivalencyList[" + i + "]: " + list.toString());
            ++i;
        }
    }
}

