/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.core.handlers;

import com.pahimar.ee3.configuration.ConfigurationSettings;
import com.pahimar.ee3.core.util.TransmutationHelper;
import com.pahimar.ee3.item.IChargeable;
import com.pahimar.ee3.item.ITransmutationStone;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.event.ForgeSubscribe;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class DrawBlockHighlightHandler {
    private static int pulse = 0;
    private static boolean doInc = true;

    @ForgeSubscribe
    public void onDrawBlockHighlightEvent(DrawBlockHighlightEvent event) {
        Minecraft minecraft = FMLClientHandler.instance().getClient();
        if (event.currentItem != null && event.currentItem.func_77973_b() instanceof ITransmutationStone && event.target.field_72313_a == EnumMovingObjectType.TILE) {
            TransmutationHelper.updateTargetBlock(event.player.field_70170_p, event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d);
            if (Minecraft.func_71382_s() && minecraft.field_71415_G && ConfigurationSettings.ENABLE_OVERLAY_WORLD_TRANSMUTATION) {
                this.drawInWorldTransmutationOverlay(event);
            }
        }
    }

    public void drawInWorldTransmutationOverlay(DrawBlockHighlightEvent event) {
        double x = (float)event.target.field_72311_b + 0.5f;
        double y = (float)event.target.field_72312_c + 0.5f;
        double z = (float)event.target.field_72309_d + 0.5f;
        double iPX = event.player.field_70169_q + (event.player.field_70165_t - event.player.field_70169_q) * (double)event.partialTicks;
        double iPY = event.player.field_70167_r + (event.player.field_70163_u - event.player.field_70167_r) * (double)event.partialTicks;
        double iPZ = event.player.field_70166_s + (event.player.field_70161_v - event.player.field_70166_s) * (double)event.partialTicks;
        int texture = event.context.field_72770_i.func_78341_b("/mods/ee3/textures/effects/noise.png");
        float xScale = 1.0f;
        float yScale = 1.0f;
        float zScale = 1.0f;
        float xShift = 0.1f;
        float yShift = 0.1f;
        float zShift = 0.1f;
        int itemChargeLevel = 0;
        if (event.currentItem.func_77973_b() instanceof IChargeable) {
            itemChargeLevel = ((IChargeable)event.currentItem.func_77973_b()).getCharge(event.currentItem);
        }
        int chargeLevel = 1 + itemChargeLevel * 2;
        ForgeDirection sideHit = ForgeDirection.getOrientation((int)event.target.field_72310_e);
        switch (sideHit) {
            case UP: {
                xScale = (float)chargeLevel + 0.1f;
                zScale = (float)chargeLevel + 0.1f;
                xShift = 0.0f;
                zShift = 0.0f;
                break;
            }
            case DOWN: {
                xScale = (float)chargeLevel + 0.1f;
                zScale = (float)chargeLevel + 0.1f;
                xShift = 0.0f;
                yShift = -yShift;
                zShift = 0.0f;
                break;
            }
            case NORTH: {
                xScale = (float)chargeLevel + 0.1f;
                yScale = (float)chargeLevel + 0.1f;
                xShift = 0.0f;
                yShift = 0.0f;
                zShift = -zShift;
                break;
            }
            case SOUTH: {
                xScale = (float)chargeLevel + 0.1f;
                yScale = (float)chargeLevel + 0.1f;
                xShift = 0.0f;
                yShift = 0.0f;
                break;
            }
            case EAST: {
                yScale = (float)chargeLevel + 0.1f;
                zScale = (float)chargeLevel + 0.1f;
                yShift = 0.0f;
                zShift = 0.0f;
                break;
            }
            case WEST: {
                yScale = (float)chargeLevel + 0.1f;
                zScale = (float)chargeLevel + 0.1f;
                xShift = -xShift;
                yShift = 0.0f;
                zShift = 0.0f;
                break;
            }
        }
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2884);
        for (int i = 0; i < 6; ++i) {
            ForgeDirection forgeDir = ForgeDirection.getOrientation((int)i);
            int zCorrection = i == 2 ? -1 : 1;
            GL11.glPushMatrix();
            GL11.glTranslated((double)(-iPX + x + (double)xShift), (double)(-iPY + y + (double)yShift), (double)(-iPZ + z + (double)zShift));
            GL11.glScalef((float)(1.0f * xScale), (float)(1.0f * yScale), (float)(1.0f * zScale));
            GL11.glRotatef((float)90.0f, (float)forgeDir.offsetX, (float)forgeDir.offsetY, (float)forgeDir.offsetZ);
            GL11.glTranslated((double)0.0, (double)0.0, (double)(0.5f * (float)zCorrection));
            GL11.glClear((int)256);
            DrawBlockHighlightHandler.renderPulsingQuad(texture, 0.75f);
            GL11.glPopMatrix();
        }
        GL11.glEnable((int)2884);
        GL11.glDepthMask((boolean)true);
    }

    public static void renderPulsingQuad(int texture, float maxTransparency) {
        float pulseTransparency = (float)DrawBlockHighlightHandler.getPulseValue() * maxTransparency / 3000.0f;
        GL11.glBindTexture((int)3553, (int)texture);
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glEnable((int)32826);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)pulseTransparency);
        tessellator.func_78382_b();
        tessellator.func_78369_a(1.0f, 1.0f, 1.0f, pulseTransparency);
        tessellator.func_78374_a(-0.5, 0.5, 0.0, 0.0, 1.0);
        tessellator.func_78374_a(0.5, 0.5, 0.0, 1.0, 1.0);
        tessellator.func_78374_a(0.5, -0.5, 0.0, 1.0, 0.0);
        tessellator.func_78374_a(-0.5, -0.5, 0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glDisable((int)32826);
    }

    private static int getPulseValue() {
        pulse = doInc ? (pulse += 8) : (pulse -= 8);
        if (pulse == 3000) {
            doInc = false;
        }
        if (pulse == 0) {
            doInc = true;
        }
        return pulse;
    }
}

