/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.configuration;

import com.pahimar.ee3.EquivalentExchange3;
import com.pahimar.ee3.configuration.ConfigurationSettings;
import com.pahimar.ee3.lib.BlockIds;
import com.pahimar.ee3.lib.ItemIds;
import cpw.mods.fml.common.FMLLog;
import java.io.File;
import java.util.logging.Level;
import net.minecraftforge.common.Configuration;

public class ConfigurationHandler {
    public static Configuration configuration;
    public static final String CATEGORY_KEYBIND = "keybindings";
    public static final String CATEGORY_GRAPHICS = "graphics";
    public static final String CATEGORY_AUDIO = "audio";
    public static final String CATEGORY_TRANSMUTATION = "transmutation";
    public static final String CATEGORY_BLOCK_PROPERTIES = "block.properties";
    public static final String CATEGORY_RED_WATER_PROPERTIES = "block.properties.red_water";
    public static final String CATEGORY_DURABILITY = "item.durability";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(File configFile) {
        configuration = new Configuration(configFile);
        try {
            configuration.load();
            ConfigurationSettings.DISPLAY_VERSION_RESULT = configuration.get("general", "version_check.display_results", true).getBoolean(true);
            ConfigurationSettings.LAST_DISCOVERED_VERSION = configuration.get("general", "version_check.last_discovered_version", "").getString();
            ConfigurationSettings.LAST_DISCOVERED_VERSION_TYPE = configuration.get("general", "version_check.last_discovered_version_type", "").getString();
            ConfigurationSettings.ENABLE_PARTICLE_FX = configuration.get(CATEGORY_GRAPHICS, "particle_fx.enabled", true).getBoolean(true);
            ConfigurationSettings.ENABLE_OVERLAY_WORLD_TRANSMUTATION = configuration.get(CATEGORY_GRAPHICS, "world_transmutation_overlay.enabled", true).getBoolean(true);
            ConfigurationSettings.TARGET_BLOCK_OVERLAY_POSITION = configuration.get(CATEGORY_GRAPHICS, "block_overlay_position", 3).getInt(3);
            try {
                ConfigurationSettings.TARGET_BLOCK_OVERLAY_SCALE = Float.parseFloat(configuration.get(CATEGORY_GRAPHICS, "block_overlay_scale", 2.5).getString());
                if (ConfigurationSettings.TARGET_BLOCK_OVERLAY_SCALE <= 0.0f) {
                    ConfigurationSettings.TARGET_BLOCK_OVERLAY_SCALE = 2.5f;
                }
            }
            catch (Exception e) {
                ConfigurationSettings.TARGET_BLOCK_OVERLAY_SCALE = 2.5f;
            }
            try {
                ConfigurationSettings.TARGET_BLOCK_OVERLAY_OPACITY = Float.parseFloat(configuration.get(CATEGORY_GRAPHICS, "block_overlay_opacity", 0.75).getString());
                if (ConfigurationSettings.TARGET_BLOCK_OVERLAY_OPACITY < 0.0f || ConfigurationSettings.TARGET_BLOCK_OVERLAY_OPACITY > 1.0f) {
                    ConfigurationSettings.TARGET_BLOCK_OVERLAY_OPACITY = 0.75f;
                }
            }
            catch (Exception e) {
                ConfigurationSettings.TARGET_BLOCK_OVERLAY_OPACITY = 0.75f;
            }
            ConfigurationSettings.ENABLE_SOUNDS = configuration.get(CATEGORY_AUDIO, "sounds.enabled", "all").getString();
            BlockIds.CALCINATOR = configuration.getBlock("calcinator", BlockIds.CALCINATOR_DEFAULT).getInt(BlockIds.CALCINATOR_DEFAULT);
            BlockIds.ALUDEL_BASE = configuration.getBlock("aludel", BlockIds.ALUDEL_BASE_DEFAULT).getInt(BlockIds.ALUDEL_BASE_DEFAULT);
            BlockIds.ALCHEMICAL_CHEST = configuration.getBlock("alchemicalChest", BlockIds.ALCHEMICAL_CHEST_DEFAULT).getInt(BlockIds.ALCHEMICAL_CHEST_DEFAULT);
            BlockIds.GLASS_BELL = configuration.getBlock("glassBell", BlockIds.GLASS_BELL_DEFAULT).getInt(BlockIds.GLASS_BELL_DEFAULT);
            BlockIds.RED_WATER_STILL = configuration.getBlock("redWaterStill", BlockIds.RED_WATER_STILL_DEFAULT).getInt(BlockIds.RED_WATER_STILL_DEFAULT);
            configuration.addCustomCategoryComment(CATEGORY_BLOCK_PROPERTIES, "Custom block properties");
            configuration.addCustomCategoryComment(CATEGORY_RED_WATER_PROPERTIES, "Configuration settings for various properties of Red Water");
            ConfigurationSettings.RED_WATER_DURATION_BASE = configuration.get(CATEGORY_RED_WATER_PROPERTIES, ConfigurationSettings.RED_WATER_DURATION_BASE_CONFIGNAME, 5).getInt(5);
            ConfigurationSettings.RED_WATER_DURATION_MODIFIER = configuration.get(CATEGORY_RED_WATER_PROPERTIES, ConfigurationSettings.RED_WATER_DURATION_MODIFIER_CONFIGNAME, 2).getInt(2);
            ConfigurationSettings.RED_WATER_RANGE_BASE = configuration.get(CATEGORY_RED_WATER_PROPERTIES, ConfigurationSettings.RED_WATER_RANGE_BASE_CONFIGNAME, 1).getInt(1);
            ConfigurationSettings.RED_WATER_RANGE_MODIFIER = configuration.get(CATEGORY_RED_WATER_PROPERTIES, ConfigurationSettings.RED_WATER_RANGE_MODIFIER_CONFIGNAME, 3).getInt(3);
            ItemIds.MINIUM_SHARD = configuration.getItem("shardMinium", ItemIds.MINIUM_SHARD_DEFAULT).getInt(ItemIds.MINIUM_SHARD_DEFAULT);
            ItemIds.INERT_STONE = configuration.getItem("stoneInert", ItemIds.INERT_STONE_DEFAULT).getInt(ItemIds.INERT_STONE_DEFAULT);
            ItemIds.MINIUM_STONE = configuration.getItem("stoneMinium", ItemIds.MINIUM_STONE_DEFAULT).getInt(ItemIds.MINIUM_STONE_DEFAULT);
            ItemIds.PHILOSOPHERS_STONE = configuration.getItem("stonePhilosophers", ItemIds.PHILOSOPHERS_STONE_DEFAULT).getInt(ItemIds.PHILOSOPHERS_STONE_DEFAULT);
            ItemIds.ALCHEMICAL_DUST = configuration.getItem("alchemicalDust", ItemIds.ALCHEMICAL_DUST_DEFAULT).getInt(ItemIds.ALCHEMICAL_DUST_DEFAULT);
            ItemIds.ALCHEMICAL_BAG = configuration.getItem("alchemicalBag", ItemIds.ALCHEMICAL_BAG_DEFAULT).getInt(ItemIds.ALCHEMICAL_BAG_DEFAULT);
            ConfigurationSettings.MINIUM_STONE_MAX_DURABILITY = configuration.get(CATEGORY_DURABILITY, "stoneMinium", 1521).getInt(1521);
            ConfigurationSettings.PHILOSOPHERS_STONE_MAX_DURABILITY = configuration.get(CATEGORY_DURABILITY, "stonePhilosophers", 10001).getInt(10001);
            configuration.addCustomCategoryComment(CATEGORY_KEYBIND, "Keybindings for Equivalent Exchange 3. See http://www.minecraftwiki.net/wiki/Key_codes for mapping of key codes to keyboard keys");
            EquivalentExchange3.proxy.setKeyBinding("key.extra", configuration.get(CATEGORY_KEYBIND, "key.extra", 46).getInt(46));
            EquivalentExchange3.proxy.setKeyBinding("key.charge", configuration.get(CATEGORY_KEYBIND, "key.charge", 47).getInt(47));
            EquivalentExchange3.proxy.setKeyBinding("key.toggle", configuration.get(CATEGORY_KEYBIND, "key.toggle", 34).getInt(34));
            EquivalentExchange3.proxy.setKeyBinding("key.release", configuration.get(CATEGORY_KEYBIND, "key.release", 19).getInt(19));
            ConfigurationSettings.TRANSMUTE_COST_ITEM = configuration.get(CATEGORY_TRANSMUTATION, "item_cost", 1).getInt(1);
            ConfigurationSettings.TRANSMUTE_COST_BLOCK = configuration.get(CATEGORY_TRANSMUTATION, "block_cost", 1).getInt(1);
            ConfigurationSettings.TRANSMUTE_COST_MOB = configuration.get(CATEGORY_TRANSMUTATION, "mob_cost", 1).getInt(1);
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.SEVERE, (Throwable)e, (String)"Equivalent Exchange 3 has had a problem loading its configuration", (Object[])new Object[0]);
        }
        finally {
            configuration.save();
        }
    }

    public static void set(String categoryName, String propertyName, String newValue) {
        configuration.load();
        if (configuration.getCategoryNames().contains(categoryName) && configuration.getCategory(categoryName).containsKey(propertyName)) {
            configuration.getCategory(categoryName).get(propertyName).set(newValue);
        }
        configuration.save();
    }
}

