/*
 * Decompiled with CFR 0.152.
 */
package magicbees.world;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Random;
import magicbees.main.utils.ChunkCoords;
import magicbees.world.WorldGeneratorHandler;
import net.minecraft.world.World;

public class WorldTicker
implements ITickHandler {
    private WorldGeneratorHandler parent;
    private HashMap chunkRegenList;

    public WorldTicker(WorldGeneratorHandler p) {
        this.parent = p;
        this.chunkRegenList = new HashMap();
    }

    public void tickStart(EnumSet type, Object ... tickData) {
    }

    public void tickEnd(EnumSet type, Object ... tickData) {
        World world = (World)tickData[0];
        int dimensionID = world.field_73011_w.field_76574_g;
        LinkedList chunkList = (LinkedList)this.chunkRegenList.get(dimensionID);
        if (chunkList != null && chunkList.size() > 0) {
            ChunkCoords coords = (ChunkCoords)chunkList.removeFirst();
            long worldSeed = world.func_72905_C();
            Random random = new Random(worldSeed);
            long xSeed = random.nextLong() >> 3;
            long zSeed = random.nextLong() >> 3;
            random.setSeed(xSeed * (long)coords.xCoord + zSeed * (long)coords.zCoord ^ worldSeed);
            this.parent.generateWorld(world, random, coords.xCoord, coords.zCoord, false);
        }
    }

    public EnumSet ticks() {
        return EnumSet.of(TickType.WORLD);
    }

    public String getLabel() {
        return "MagicBees".toLowerCase() + ".world";
    }

    public void queueChunkCoords(ChunkCoords coords) {
        if (!this.chunkRegenList.containsKey(coords.dimension)) {
            this.chunkRegenList.put(coords.dimension, new LinkedList());
        }
        ((LinkedList)this.chunkRegenList.get(coords.dimension)).addLast(coords);
    }

    public LinkedList getChunksToGen(int dimensionId) {
        return (LinkedList)this.chunkRegenList.get(dimensionId);
    }
}

