/*
 * Decompiled with CFR 0.152.
 */
package magicbees.tileentity;

import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import magicbees.bees.BeeManager;
import magicbees.tileentity.EffectJarHousing;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class TileEntityEffectJar
extends TileEntity
implements IInventory {
    public static final String tileEntityName = "MagicBees".toLowerCase() + ".effectJar";
    private String ownerName;
    private EffectJarHousing housingLogic;
    private static final int SLOT_COUNT = 2;
    public static final int DRONE_SLOT = 0;
    public static final int QUEEN_SLOT = 1;
    private ItemStack[] beeSlots;
    private IEffectData[] effectData = new IEffectData[2];
    private int throttle;
    public int currentBeeHealth;
    public int currentBeeColour;

    public TileEntityEffectJar() {
        this.beeSlots = new ItemStack[2];
    }

    public void setOwner(EntityPlayer player) {
        this.ownerName = player.field_71092_bJ;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public String getOwner() {
        return this.ownerName;
    }

    public int func_70302_i_() {
        return this.beeSlots.length - 1;
    }

    public ItemStack func_70301_a(int slot) {
        return this.beeSlots[slot];
    }

    public void func_70316_g() {
        if (this.beeSlots[1] != null) {
            IBee queen = BeeManager.beeRoot.getMember(this.beeSlots[1]);
            this.currentBeeHealth = queen.getHealth() * 100 / queen.getMaxHealth();
            this.currentBeeColour = queen.getGenome().getPrimary().getIconColour(0);
            EffectJarHousing housingLogic = EffectJarHousing.getFor(this);
            this.effectData = queen.doEffect(this.effectData, (IBeeHousing)housingLogic);
            if (this.field_70331_k.func_72820_D() % 5L == 0L) {
                this.effectData = queen.doFX(this.effectData, (IBeeHousing)housingLogic);
            }
            if (this.throttle > 550) {
                this.throttle = 0;
                queen.age(this.field_70331_k, 0.26f);
                if (queen.getHealth() == 0) {
                    this.beeSlots[1] = null;
                    this.currentBeeHealth = 0;
                    this.currentBeeColour = 0xFFFFFF;
                } else {
                    queen.writeToNBT(this.beeSlots[1].field_77990_d);
                }
                this.func_70296_d();
            } else {
                ++this.throttle;
            }
        } else if (this.beeSlots[0] != null) {
            ItemStack droneStack = this.beeSlots[0];
            if (BeeManager.beeRoot.isDrone(droneStack)) {
                IBee bee = BeeManager.beeRoot.getMember(droneStack);
                if (droneStack.field_77994_a == 1) {
                    this.beeSlots[0] = null;
                } else {
                    --droneStack.field_77994_a;
                }
                this.beeSlots[1] = droneStack.func_77946_l();
                this.beeSlots[1].field_77994_a = 1;
                int current = bee.getHealth();
                int max = bee.getMaxHealth();
                this.currentBeeHealth = current * 100 / max;
                this.currentBeeColour = bee.getGenome().getPrimary().getIconColour(0);
            }
            this.func_70296_d();
        }
    }

    public ItemStack func_70298_a(int slot, int count) {
        ItemStack value = null;
        if (this.beeSlots[slot] != null) {
            value = this.beeSlots[slot].func_77946_l();
            value.field_77994_a = Math.min(count, this.beeSlots[slot].field_77994_a);
            this.beeSlots[slot].field_77994_a -= value.field_77994_a;
            if (this.beeSlots[slot].field_77994_a == 0) {
                this.beeSlots[slot] = null;
            }
        }
        this.func_70296_d();
        return value;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack value = null;
        if (this.beeSlots[slot] != null) {
            value = this.beeSlots[slot];
            this.beeSlots[slot] = null;
        }
        this.func_70296_d();
        return value;
    }

    public void func_70307_a(NBTTagCompound tagRoot) {
        super.func_70307_a(tagRoot);
        NBTTagList nbttaglist = tagRoot.func_74761_m("Items");
        this.beeSlots = new ItemStack[2];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.func_74743_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.beeSlots.length) continue;
            this.beeSlots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.currentBeeHealth = tagRoot.func_74762_e("currentBeeHealth");
        this.throttle = tagRoot.func_74762_e("throttle");
    }

    public void func_70310_b(NBTTagCompound tagRoot) {
        super.func_70310_b(tagRoot);
        NBTTagList inventory = new NBTTagList();
        for (int i = 0; i < this.beeSlots.length; ++i) {
            if (this.beeSlots[i] == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", (byte)i);
            this.beeSlots[i].func_77955_b(itemTag);
            inventory.func_74742_a((NBTBase)itemTag);
        }
        tagRoot.func_74782_a("Items", (NBTBase)inventory);
        tagRoot.func_74768_a("currentBeeHealth", this.currentBeeHealth);
        tagRoot.func_74768_a("throttle", this.throttle);
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.beeSlots[slot] = itemStack;
        if (this.beeSlots[slot] != null) {
            this.beeSlots[slot].field_77994_a = Math.min(this.beeSlots[slot].field_77994_a, this.beeSlots[slot].func_77973_b().func_77639_j());
        }
        this.func_70296_d();
    }

    public String func_70303_b() {
        return "container.effectJar";
    }

    public boolean func_94042_c() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }
}

