/*
 * Decompiled with CFR 0.152.
 */
package magicbees.main.utils.compat;

import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.genetics.IAllele;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import thaumcraft.api.ObjectTags;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.crafting.ShapelessInfusionCraftingRecipes;
import thaumcraft.api.research.ResearchList;

public class ShapelessBeeInfusionCraftingRecipe
extends ShapelessInfusionCraftingRecipes {
    private String alleleId;
    private byte alleleSlot;

    public static void createNewRecipe(String key, String researchKey, ItemStack output, Object[] input, int auraCost, ObjectTags tags, IAllele allele, EnumBeeChromosome slot) {
        ArrayList<ItemStack> inputList = new ArrayList<ItemStack>(input.length);
        for (Object item : input) {
            if (item instanceof ItemStack) {
                inputList.add(((ItemStack)item).func_77946_l());
                continue;
            }
            if (item instanceof Item) {
                inputList.add(new ItemStack((Item)item));
                continue;
            }
            if (item instanceof Block) {
                inputList.add(new ItemStack((Block)item));
                continue;
            }
            throw new RuntimeException("Invalid shapeless crafting recipe!");
        }
        ThaumcraftApi.getCraftingRecipes().add(new ShapelessBeeInfusionCraftingRecipe(key, output, inputList, auraCost, tags, allele, slot));
        ResearchList.craftingRecipesForResearch.put(researchKey, Arrays.asList(ThaumcraftApi.getCraftingRecipes().size() - 1));
    }

    private ShapelessBeeInfusionCraftingRecipe(String key, ItemStack output, List itemList, int cost, ObjectTags tags, IAllele allele, EnumBeeChromosome slot) {
        super(key, output, itemList, cost, tags);
        this.alleleId = allele.getUID();
        this.alleleSlot = (byte)slot.ordinal();
    }

    public boolean matches(IInventory craftingInventory, EntityPlayer player) {
        ArrayList recipeItemsList = new ArrayList(this.recipeItems);
        boolean invalidItemFound = false;
        if (this.key.length() == 0 || this.key.length() > 0 && ThaumcraftApiHelper.isResearchComplete((String)player.field_71092_bJ, (String)this.key)) {
            for (int i = 0; i < 3 && !invalidItemFound; ++i) {
                for (int j = 0; j < 3 && !invalidItemFound; ++j) {
                    ItemStack itemStack = ThaumcraftApiHelper.getStackInRowAndColumn((Object)craftingInventory, (int)j, (int)i);
                    if (itemStack == null) continue;
                    Iterator itr = recipeItemsList.iterator();
                    boolean currentItemInRecipe = false;
                    while (itr.hasNext()) {
                        ItemStack recipeItem = (ItemStack)itr.next();
                        if (itemStack.field_77993_c == recipeItem.field_77993_c && (recipeItem.func_77960_j() == -1 || itemStack.func_77960_j() == recipeItem.func_77960_j())) {
                            currentItemInRecipe = recipeItem.func_77942_o() ? this.hasMatchingChromosome(itemStack) : true;
                        }
                        if (!currentItemInRecipe) continue;
                        itr.remove();
                        break;
                    }
                    if (currentItemInRecipe) continue;
                    invalidItemFound = true;
                }
            }
        }
        return recipeItemsList.isEmpty() && !invalidItemFound;
    }

    private boolean hasMatchingChromosome(ItemStack itemStack) {
        NBTTagCompound genome;
        boolean genesMatch = false;
        NBTTagCompound compoundRoot = itemStack.func_77978_p();
        if (compoundRoot.func_74764_b("Genome") && (genome = compoundRoot.func_74775_l("Genome")).func_74764_b("Chromosomes")) {
            NBTTagList chromosomes = genome.func_74761_m("Chromosomes");
            for (int i = 0; i < chromosomes.func_74745_c() && !genesMatch; ++i) {
                NBTTagCompound genes = (NBTTagCompound)chromosomes.func_74743_b(i);
                if (!genes.func_74764_b("Slot") || genes.func_74771_c("Slot") != this.alleleSlot || !genes.func_74779_i("UID0").equals(this.alleleId) || !genes.func_74779_i("UID1").equals(this.alleleId)) continue;
                genesMatch = true;
            }
        }
        return genesMatch;
    }
}

