/*
 * Decompiled with CFR 0.152.
 */
package magicbees.main.utils.compat;

import cpw.mods.fml.common.FMLLog;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ItemInterface;
import forestry.api.genetics.IAllele;
import java.lang.reflect.Method;
import magicbees.main.Config;
import net.minecraft.block.Block;

public class ForestryHelper {
    public static final String Name = "Forestry";

    public static void getBlocks() {
        try {
            Class<?> c = Class.forName("forestry.core.config.ForestryBlock");
            Config.fAlvearyBlock = (Block)c.getField("alveary").get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void getItems() {
        Config.fBeeComb = ItemInterface.getItem((String)"beeComb").func_77973_b();
        Config.fPollen = ItemInterface.getItem((String)"pollen").func_77973_b();
        Config.fCraftingResource = ItemInterface.getItem((String)"craftingMaterial").func_77973_b();
        Config.fHoneyDrop = ItemInterface.getItem((String)"honeyDrop").func_77973_b();
        Config.fHoneydew = ItemInterface.getItem((String)"honeydew").func_77973_b();
    }

    public static IAllele[] getTemplateForestryForSpecies(String speciesName) {
        IAllele[] template = null;
        try {
            Class<?> c = Class.forName("forestry.apiculture.genetics.BeeTemplates");
            Method m = c.getMethod("get" + speciesName + "Template", new Class[0]);
            template = (IAllele[])m.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            FMLLog.severe((String)"Could not get Forestry template for %s.", (Object[])new Object[]{speciesName});
            e.printStackTrace();
        }
        return template;
    }

    public static EnumTemperature getEnumTemperatureFromValue(float rawTemp) {
        EnumTemperature value = EnumTemperature.ICY;
        if (rawTemp >= 2.0f) {
            value = EnumTemperature.HOT;
        } else if (rawTemp >= 1.2f) {
            value = EnumTemperature.WARM;
        } else if (rawTemp >= 0.2f) {
            value = EnumTemperature.NORMAL;
        } else if (rawTemp >= 0.05f) {
            value = EnumTemperature.COLD;
        }
        return value;
    }

    public static EnumHumidity getEnumHumidityFromValue(float rawHumidity) {
        EnumHumidity value = EnumHumidity.ARID;
        if (rawHumidity >= 0.9f) {
            value = EnumHumidity.DAMP;
        } else if (rawHumidity >= 0.3f) {
            value = EnumHumidity.NORMAL;
        }
        return value;
    }

    public static enum Tube {
        COPPER,
        TIN,
        BRONZE,
        IRON,
        GOLD,
        DIAMOND,
        OBSIDIAN,
        BLAZE,
        RUBBER,
        EMERALD,
        APATITE,
        LAPIS;

    }

    public static enum CircuitBoard {
        BASIC,
        ENHANCED,
        REFINED,
        INTRICATE;

    }

    public static enum Pollen {
        NORMAL,
        CRYSTALLINE;

    }

    public static enum Propolis {
        NORMAL,
        STICKY,
        PULSATING,
        SILKY;

    }

    public static enum Comb {
        HONEY,
        COCOA,
        SIMMERING,
        STRINGY,
        FROZEN,
        DRIPPING,
        SILKY,
        PARCHED,
        MYSTERIOUS,
        IRRADIATED,
        POWDERY,
        REDDENED,
        DARKENED,
        OMEGA,
        WHEATEN,
        MOSSY;

    }

    public static enum CraftingMaterial {
        PULSATING_DUST,
        PULSATING_MESH,
        SILK_WISP,
        WOVEN_SILK,
        DISSIPATION_CHARGE,
        ICE_SHARD,
        SCENTED_PANELING;

    }

    public static enum BlockResource {
        APATITE,
        COPPER,
        TIN;

    }
}

