/*
 * Decompiled with CFR 0.152.
 */
package magicbees.bees;

import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import java.util.List;
import magicbees.bees.Allele;
import magicbees.main.MagicBees;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;

public abstract class AlleleEffect
extends Allele
implements IAlleleBeeEffect {
    protected int throttle;

    public AlleleEffect(String id, boolean isDominant, int timeout) {
        super("effect" + id, isDominant);
        this.throttle = timeout;
    }

    public boolean isCombinable() {
        return false;
    }

    public abstract IEffectData validateStorage(IEffectData var1);

    public final IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        int count = storedData.getInteger(0);
        if (count >= this.throttle) {
            storedData = this.doEffectThrottled(genome, storedData, housing);
        } else {
            storedData.setInteger(0, count + 1);
        }
        return storedData;
    }

    protected abstract IEffectData doEffectThrottled(IBeeGenome var1, IEffectData var2, IBeeHousing var3);

    public IEffectData doFX(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        int[] area = genome.getTerritory();
        float mod = housing.getTerritoryModifier(genome, 1.0f);
        area[0] = Math.max((int)((float)area[0] * mod), 1);
        area[1] = Math.max((int)((float)area[1] * mod), 1);
        area[2] = Math.max((int)((float)area[2] * mod), 1);
        MagicBees.proxy.drawBeeEffects(housing.getWorld(), housing.getXCoord(), housing.getYCoord(), housing.getZCoord(), genome.getPrimary().getIconColour(0), area[0], area[1], area[2]);
        return storedData;
    }

    protected List getEntitiesWithinRange(IBeeGenome genome, IBeeHousing housing) {
        int[] area = genome.getTerritory();
        int[] min = new int[3];
        int[] max = new int[3];
        min[0] = housing.getXCoord() - area[0] / 2;
        max[0] = housing.getXCoord() + area[0] / 2;
        min[1] = housing.getYCoord() - area[1] / 2;
        max[1] = housing.getYCoord() + area[1] / 2;
        min[2] = housing.getZCoord() - area[2] / 2;
        max[2] = housing.getZCoord() + area[2] / 2;
        AxisAlignedBB bounds = AxisAlignedBB.func_72332_a().func_72299_a((double)min[0], (double)min[1], (double)min[2], (double)max[0], (double)max[1], (double)max[2]);
        return housing.getWorld().func_72872_a(EntityPlayer.class, bounds);
    }
}

