/*
 * Decompiled with CFR 0.152.
 */
package magicbees.bees;

import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleEffect;
import forestry.api.genetics.IAlleleFlowers;
import forestry.api.genetics.IAlleleRegistry;
import magicbees.bees.AlleleEffectAuraNodeAttract;
import magicbees.bees.AlleleEffectAuraNodeCharge;
import magicbees.bees.AlleleEffectAuraNodeFlux;
import magicbees.bees.AlleleEffectAuraNodePurify;
import magicbees.bees.AlleleEffectCure;
import magicbees.bees.AlleleEffectPotion;
import magicbees.bees.AlleleEffectSpawnMob;
import magicbees.bees.AlleleEffectSpawnMobWeighted;
import magicbees.bees.AlleleEffectSpawnWisp;
import magicbees.bees.AlleleFloat;
import magicbees.bees.AlleleFlower;
import magicbees.bees.BeeSpecies;
import magicbees.bees.FlowerProviderArsMagicaFlower;
import magicbees.bees.FlowerProviderAuraNode;
import magicbees.bees.FlowerProviderBookshelf;
import magicbees.bees.FlowerProviderThaumcraftFlower;
import magicbees.main.utils.LocalizationManager;
import magicbees.main.utils.compat.ArsMagicaHelper;
import magicbees.main.utils.compat.ThaumcraftHelper;
import net.minecraft.potion.Potion;

public class Allele
implements IAllele {
    public static AlleleFloat speedBlinding;
    public static IAlleleFlowers flowerBookshelf;
    public static IAlleleFlowers flowerThaumcraft;
    public static IAlleleFlowers flowerArsMagica;
    public static IAlleleFlowers flowerAuraNode;
    public static IAlleleEffect effectCleansing;
    public static IAlleleEffect effectDigSpeed;
    public static IAlleleEffect effectMoveSpeed;
    public static IAlleleEffect effectSlowSpeed;
    public static IAlleleEffect effectWithering;
    public static IAlleleEffect spawnBrainyZombie;
    public static IAlleleEffect spawnWisp;
    public static IAlleleEffect spawnBats;
    public static IAlleleEffect spawnGhast;
    public static IAlleleEffect spawnSpider;
    public static IAlleleEffect spawnBlaze;
    public static IAlleleEffect spawnManaDrainer;
    public static IAlleleEffect spawnWispOrHecate;
    public static IAlleleEffect effectNodeAttract;
    public static IAlleleEffect effectNodePurify;
    public static IAlleleEffect effectNodeFlux;
    public static IAlleleEffect effectNodeCharge;
    private String uid;
    private boolean dominant;

    public static void setupAdditionalAlleles() {
        speedBlinding = new AlleleFloat("speedBlinding", 2.0f, false);
        flowerBookshelf = new AlleleFlower("Bookshelf", new FlowerProviderBookshelf(), true);
        if (ThaumcraftHelper.isActive()) {
            flowerThaumcraft = new AlleleFlower("ThaumcraftPlant", new FlowerProviderThaumcraftFlower(), false);
            flowerAuraNode = new AlleleFlower("AuraNode", new FlowerProviderAuraNode(), true);
            spawnBrainyZombie = new AlleleEffectSpawnMob("Brainy", false, ThaumcraftHelper.Entity.BRAINY_ZOMBIE.entityID).setAggrosPlayerOnSpawn().setThrottle(800).setSpawnsOnPlayerNear(null).setMaxMobsInSpawnZone(2);
            spawnBats = new AlleleEffectSpawnMob("Batty", false, ThaumcraftHelper.Entity.FIREBAT.entityID).setThrottle(300).setSpawnsOnPlayerNear("Bat");
            spawnWisp = new AlleleEffectSpawnWisp("Wispy", false, ThaumcraftHelper.Entity.WISP.entityID, "thaumcraft.wisplive").setThrottle(1800).setChanceToSpawn(79);
        } else {
            flowerThaumcraft = flowerAuraNode = (IAlleleFlowers)Allele.getBaseAllele("flowersVanilla");
            spawnBats = spawnWisp = (IAlleleEffect)Allele.getBaseAllele("effectNone");
            spawnBrainyZombie = spawnWisp;
        }
        if (ArsMagicaHelper.isActive()) {
            flowerArsMagica = new AlleleFlower("flowerArsMagicaPlant", new FlowerProviderArsMagicaFlower(), false);
            spawnManaDrainer = new AlleleEffectSpawnMobWeighted("ManaDrain", true, 20, new String[]{"ArsMagica.MobManaCreeper", "ArsMagica.ManaVortex"}, new int[]{60, 2});
            spawnWispOrHecate = new AlleleEffectSpawnMobWeighted("AMWisp", true, 20, new String[]{"ArsMagica.MobWisp", "ArsMagica.MobHecate"}, new int[]{40, 3});
        } else {
            flowerArsMagica = (IAlleleFlowers)Allele.getBaseAllele("flowersVanilla");
            spawnManaDrainer = spawnWispOrHecate = (IAlleleEffect)Allele.getBaseAllele("effectNone");
        }
        effectNodeAttract = new AlleleEffectAuraNodeAttract("NodeAttract", false, 400);
        effectNodePurify = new AlleleEffectAuraNodePurify("NodePurify", false, 600, 150);
        effectNodeFlux = new AlleleEffectAuraNodeFlux("NodeFlux", true, 300, 300);
        effectNodeCharge = new AlleleEffectAuraNodeCharge("NodeCharge", true, 1200);
        effectCleansing = new AlleleEffectCure("Curative", false);
        effectDigSpeed = new AlleleEffectPotion("DigSpeed", Potion.field_76422_e, 15, false);
        effectMoveSpeed = new AlleleEffectPotion("MoveSpeed", Potion.field_76424_c, 10, false);
        effectSlowSpeed = new AlleleEffectPotion("SlowSpeed", Potion.field_76421_d, 3, false).setMalicious();
        effectWithering = new AlleleEffectPotion("Withering", Potion.field_82731_v, 10, false).setMalicious();
        spawnGhast = new AlleleEffectSpawnMob("Ghastly", false, "Ghast", "mob.ghast.moan").setThrottle(2060).setChanceToSpawn(10).setMaxMobsInSpawnZone(1);
        spawnSpider = new AlleleEffectSpawnMob("Spidery", false, "Spider", "mob.spider.step").setThrottle(400).setChanceToSpawn(70).setMaxMobsInSpawnZone(4);
        spawnBlaze = new AlleleEffectSpawnMob("Ablaze", false, "Blaze", "mob.blaze.breathe").setThrottle(800).setChanceToSpawn(60).setMaxMobsInSpawnZone(2);
    }

    public static void registerDeprecatedAlleleReplacements() {
        IAlleleRegistry registry = AlleleManager.alleleRegistry;
        registry.registerDeprecatedAlleleReplacement("thaumicbees.fertilityHighDominant", Allele.getBaseAllele("fertilityHigh"));
        registry.registerDeprecatedAlleleReplacement("thaumicbees.flowerflowerBookshelf", (IAllele)flowerBookshelf);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speedBlinding", (IAllele)speedBlinding);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.effectNodeAttract", (IAllele)effectNodeAttract);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.effectNodePurify", (IAllele)effectNodePurify);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.effectNodeFlux", (IAllele)effectNodeFlux);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.effectNodeCharge", (IAllele)effectNodeCharge);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.effectCurative", (IAllele)effectCleansing);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.effecteffectDigSpeed", (IAllele)effectDigSpeed);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.effecteffectMoveSpeed", (IAllele)effectMoveSpeed);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.effecteffectSlowSpeed", (IAllele)effectSlowSpeed);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.Ghast", (IAllele)spawnGhast);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.Spider", (IAllele)spawnSpider);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesEsoteric", (IAllele)BeeSpecies.ESOTERIC);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesMysterious", (IAllele)BeeSpecies.MYSTERIOUS);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesArcane", (IAllele)BeeSpecies.ARCANE);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesCharmed", (IAllele)BeeSpecies.CHARMED);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesEnchanted", (IAllele)BeeSpecies.ENCHANTED);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesSupernatural", (IAllele)BeeSpecies.SUPERNATURAL);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesPupil", (IAllele)BeeSpecies.PUPIL);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesScholarly", (IAllele)BeeSpecies.SCHOLARLY);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesSavant", (IAllele)BeeSpecies.SAVANT);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesAware", (IAllele)BeeSpecies.AWARE);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesSpirit", (IAllele)BeeSpecies.SPIRIT);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesSoul", (IAllele)BeeSpecies.SOUL);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesSkulking", (IAllele)BeeSpecies.SKULKING);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesGhastly", (IAllele)BeeSpecies.GHASTLY);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesSpidery", (IAllele)BeeSpecies.SPIDERY);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesTimely", (IAllele)BeeSpecies.TIMELY);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesLordly", (IAllele)BeeSpecies.LORDLY);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesDoctoral", (IAllele)BeeSpecies.DOCTORAL);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesIron", (IAllele)BeeSpecies.IRON);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesGold", (IAllele)BeeSpecies.GOLD);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesCopper", (IAllele)BeeSpecies.COPPER);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesTin", (IAllele)BeeSpecies.TIN);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesSilver", (IAllele)BeeSpecies.SILVER);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesLead", (IAllele)BeeSpecies.LEAD);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesDiamond", (IAllele)BeeSpecies.DIAMOND);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesEmerald", (IAllele)BeeSpecies.EMERALD);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesApatite", (IAllele)BeeSpecies.APATITE);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesStark", (IAllele)BeeSpecies.TC_STARK);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesAura", (IAllele)BeeSpecies.TC_AIR);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesIgnis", (IAllele)BeeSpecies.TC_FIRE);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesAqua", (IAllele)BeeSpecies.TC_WATER);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesSolum", (IAllele)BeeSpecies.TC_EARTH);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesPraecantatio", (IAllele)BeeSpecies.TC_MAGIC);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesVis", (IAllele)BeeSpecies.TC_VIS);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesPure", (IAllele)BeeSpecies.TC_PURE);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesFlux", (IAllele)BeeSpecies.TC_FLUX);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesNode", (IAllele)BeeSpecies.TC_ATTRACT);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesRejuvenating", (IAllele)BeeSpecies.TC_REJUVENATING);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesBrainy", (IAllele)BeeSpecies.TC_BRAINY);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesGossamer", (IAllele)BeeSpecies.TC_WISPY);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesWispy", (IAllele)BeeSpecies.TC_WISPY);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesBatty", (IAllele)BeeSpecies.TC_BATTY);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesChicken", (IAllele)BeeSpecies.TC_CHICKEN);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesBeef", (IAllele)BeeSpecies.TC_BEEF);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesPork", (IAllele)BeeSpecies.TC_PORK);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesMinium", (IAllele)BeeSpecies.EE_MINIUM);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesEssence", (IAllele)BeeSpecies.AM_ESSENCE);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesQuintessence", (IAllele)BeeSpecies.AM_QUINTESSENCE);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesErde", (IAllele)BeeSpecies.AM_EARTH);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesLuft", (IAllele)BeeSpecies.AM_AIR);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesFeuer", (IAllele)BeeSpecies.AM_FIRE);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesWasser", (IAllele)BeeSpecies.AM_WATER);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesBlitz", (IAllele)BeeSpecies.AM_LIGHTNING);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesStaude", (IAllele)BeeSpecies.AM_PLANT);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesEis", (IAllele)BeeSpecies.AM_ICE);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesMagma", (IAllele)BeeSpecies.AM_MAGMA);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesArkanen", (IAllele)BeeSpecies.AM_ARCANE);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesVortex", (IAllele)BeeSpecies.AM_VORTEX);
        registry.registerDeprecatedAlleleReplacement("thaumicbees.speciesWight", (IAllele)BeeSpecies.AM_WIGHT);
    }

    public static IAlleleBeeSpecies getBaseSpecies(String name) {
        return (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.species" + name);
    }

    public static IAlleleBeeSpecies getExtraSpecies(String name) {
        return (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("extrabees.species." + name);
    }

    public static IAllele getBaseAllele(String name) {
        return AlleleManager.alleleRegistry.getAllele("forestry." + name);
    }

    public static IAllele getAllele(String name) {
        return AlleleManager.alleleRegistry.getAllele(name);
    }

    public Allele(String id, boolean isDominant) {
        this.uid = "magicbees." + id;
        this.dominant = isDominant;
        AlleleManager.alleleRegistry.registerAllele((IAllele)this);
    }

    public String getUID() {
        return this.uid;
    }

    public boolean isDominant() {
        return this.dominant;
    }

    public String getName() {
        return LocalizationManager.getLocalizedString(this.getUID());
    }
}

