/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.core.inventory;

import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.core.inventory.IInventoryManager;
import powercrystals.core.inventory.InventoryManagerLegacy;
import powercrystals.core.inventory.InventoryManagerSided;
import powercrystals.core.inventory.InventoryManagerStandard;

public class InventoryManager {
    public static IInventoryManager create(IInventory inventory, ForgeDirection targetSide) {
        if (inventory instanceof ISidedInventory) {
            return new InventoryManagerSided((ISidedInventory)inventory, targetSide);
        }
        if (inventory instanceof net.minecraftforge.common.ISidedInventory) {
            return new InventoryManagerLegacy((net.minecraftforge.common.ISidedInventory)inventory, targetSide);
        }
        if (inventory instanceof IInventory) {
            return new InventoryManagerStandard(inventory, targetSide);
        }
        return null;
    }

    public static boolean stacksEqual(ItemStack s1, ItemStack s2) {
        return InventoryManager.stacksEqual(s1, s2, true);
    }

    public static boolean stacksEqual(ItemStack s1, ItemStack s2, boolean nbtSensitive) {
        if (s1 == null || s2 == null) {
            return false;
        }
        if (!s1.func_77969_a(s2)) {
            return false;
        }
        if (nbtSensitive) {
            if (s1.func_77978_p() == null && s2.func_77978_p() == null) {
                return true;
            }
            if (s1.func_77978_p() == null || s2.func_77978_p() == null) {
                return false;
            }
            return s1.func_77978_p().equals((Object)s2.func_77978_p());
        }
        return true;
    }
}

