/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.core.gui.controls;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import org.lwjgl.opengl.GL11;
import powercrystals.core.gui.Control;
import powercrystals.core.gui.GuiColor;
import powercrystals.core.gui.GuiRender;
import powercrystals.core.gui.controls.IListBoxElement;

public abstract class ListBox
extends Control {
    public int borderColor = new GuiColor(120, 120, 120, 255).getColor();
    public int backgroundColor = new GuiColor(0, 0, 0, 255).getColor();
    public int selectedLineColor = new GuiColor(0, 0, 0, 255).getColor();
    public int textColor = new GuiColor(150, 150, 150, 255).getColor();
    public int selectedTextColor = new GuiColor(255, 255, 255, 255).getColor();
    private int _marginTop = 2;
    private int _marginLeft = 2;
    private int _marginRight = 2;
    private int _marginBottom = 2;
    private List _elements = new LinkedList();
    private int _firstIndexDisplayed;
    private int _selectedIndex;

    public ListBox(GuiContainer containerScreen, int x, int y, int width, int height) {
        super(containerScreen, x, y, width, height);
    }

    public void add(IListBoxElement element) {
        this._elements.add(element);
    }

    public void add(Collection elements) {
        this._elements.addAll(elements);
    }

    public void remove(IListBoxElement element) {
        this._elements.remove(element);
    }

    public void removeAt(int index) {
        this._elements.remove(index);
    }

    public int getContentWidth() {
        return this.width - this._marginLeft - this._marginRight;
    }

    public int getContentHeight() {
        return this.height - this._marginTop - this._marginBottom;
    }

    protected int getContentTop() {
        return this.y + this._marginTop;
    }

    protected int getContentLeft() {
        return this.x + this._marginLeft;
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        GuiRender.drawRect(this.x - 1, this.y - 1, this.x + this.width + 1, this.y + this.height + 1, this.borderColor);
        GuiRender.drawRect(this.x, this.y, this.x + this.width, this.y + this.height, this.backgroundColor);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        int heightDrawn = 0;
        GL11.glDisable((int)2896);
        for (int nextElement = this._firstIndexDisplayed; nextElement < this._elements.size() && heightDrawn + ((IListBoxElement)this._elements.get(nextElement)).getHeight() <= this.getContentHeight(); ++nextElement) {
            if (nextElement == this._selectedIndex) {
                ((IListBoxElement)this._elements.get(nextElement)).draw(this, this.getContentLeft(), this.getContentTop() + heightDrawn, this.selectedLineColor, this.selectedTextColor);
            } else {
                ((IListBoxElement)this._elements.get(nextElement)).draw(this, this.getContentLeft(), this.getContentTop() + heightDrawn, this.backgroundColor, this.textColor);
            }
            heightDrawn += ((IListBoxElement)this._elements.get(nextElement)).getHeight();
        }
    }

    @Override
    public boolean onMousePressed(int mouseX, int mouseY, int mouseButton) {
        int elementHeight;
        int heightChecked = 0;
        for (int i = this._firstIndexDisplayed; i < this._elements.size() && heightChecked + (elementHeight = ((IListBoxElement)this._elements.get(i)).getHeight()) <= this.getContentHeight(); ++i) {
            if (this.getContentTop() + heightChecked <= mouseY && this.getContentTop() + heightChecked + elementHeight >= mouseY) {
                this.setSelectedIndex(i);
                this.onElementClicked((IListBoxElement)this._elements.get(i));
                break;
            }
            heightChecked += elementHeight;
        }
        return true;
    }

    @Override
    public boolean onMouseWheel(int mouseX, int mouseY, int movement) {
        if (movement > 0) {
            this.scrollUp();
        } else if (movement < 0) {
            this.scrollDown();
        }
        return true;
    }

    public void scrollDown() {
        int heightDisplayed = 0;
        int elementsDisplayed = 0;
        for (int i = this._firstIndexDisplayed; i < this._elements.size() && heightDisplayed + ((IListBoxElement)this._elements.get(i)).getHeight() <= this.height; ++i) {
            heightDisplayed += ((IListBoxElement)this._elements.get(i)).getHeight();
            ++elementsDisplayed;
        }
        if (this._firstIndexDisplayed + elementsDisplayed < this._elements.size()) {
            ++this._firstIndexDisplayed;
        }
        this.onScroll(this._firstIndexDisplayed);
    }

    public void scrollUp() {
        if (this._firstIndexDisplayed > 0) {
            --this._firstIndexDisplayed;
        }
        this.onScroll(this._firstIndexDisplayed);
    }

    public int getLastScrollPosition() {
        int position = this._elements.size() - 1;
        for (int heightUsed = ((IListBoxElement)this._elements.get(position)).getHeight(); position > 0 && heightUsed < this.height; heightUsed += ((IListBoxElement)this._elements.get(--position)).getHeight()) {
        }
        return position + 1;
    }

    public int getSelectedIndex() {
        return this._selectedIndex;
    }

    public int getIndexOf(Object value) {
        for (int i = 0; i < this._elements.size(); ++i) {
            if (!((IListBoxElement)this._elements.get(i)).getValue().equals(value)) continue;
            return i;
        }
        return -1;
    }

    public IListBoxElement getSelectedElement() {
        return (IListBoxElement)this._elements.get(this._selectedIndex);
    }

    public void setSelectedIndex(int index) {
        if (index >= 0 && index < this._elements.size() && index != this._selectedIndex) {
            this._selectedIndex = index;
            this.onSelectionChanged(this._selectedIndex, this.getSelectedElement());
        }
    }

    public IListBoxElement getElement(int index) {
        return (IListBoxElement)this._elements.get(index);
    }

    public int getElementCount() {
        return this._elements.size();
    }

    public void scrollTo(int index) {
        if (index >= 0 && index < this._elements.size()) {
            this._firstIndexDisplayed = index;
        }
    }

    protected void onElementClicked(IListBoxElement element) {
    }

    protected void onScroll(int newStartIndex) {
    }

    protected abstract void onSelectionChanged(int var1, IListBoxElement var2);
}

