/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.core.gui.controls;

import net.minecraft.client.gui.inventory.GuiContainer;
import org.lwjgl.opengl.GL11;
import powercrystals.core.gui.Control;
import powercrystals.core.gui.GuiRender;

public abstract class Button
extends Control {
    private String _text;

    public Button(GuiContainer containerScreen, int x, int y, int width, int height, String text) {
        super(containerScreen, x, y, width, height);
        this._text = text;
    }

    public void setText(String text) {
        this._text = text;
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        if (this.enabled && this.isPointInBounds(mouseX, mouseY)) {
            GL11.glBindTexture((int)3553, (int)this.containerScreen.field_73882_e.field_71446_o.func_78341_b("/powercrystals/core/textures/button_hover.png"));
        } else if (this.enabled) {
            GL11.glBindTexture((int)3553, (int)this.containerScreen.field_73882_e.field_71446_o.func_78341_b("/powercrystals/core/textures/button_enabled.png"));
        } else {
            GL11.glBindTexture((int)3553, (int)this.containerScreen.field_73882_e.field_71446_o.func_78341_b("/powercrystals/core/textures/button_disabled.png"));
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiRender.drawTexturedModalRect(this.x, this.y, 0, 0, this.width / 2, this.height / 2);
        GuiRender.drawTexturedModalRect(this.x, this.y + this.height / 2, 0, 256 - this.height / 2, this.width / 2, this.height / 2);
        GuiRender.drawTexturedModalRect(this.x + this.width / 2, this.y, 256 - this.width / 2, 0, this.width / 2, this.height / 2);
        GuiRender.drawTexturedModalRect(this.x + this.width / 2, this.y + this.height / 2, 256 - this.width / 2, 256 - this.height / 2, this.width / 2, this.height / 2);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        String text = this.containerScreen.field_73886_k.func_78269_a(this._text, this.width - 4);
        GuiRender.drawCenteredString(this.containerScreen.field_73886_k, text, this.x + this.width / 2, this.y + (this.height - 8) / 2, this.getTextColor(mouseX, mouseY));
    }

    protected int getTextColor(int mouseX, int mouseY) {
        if (this.enabled && this.isPointInBounds(mouseX, mouseY)) {
            return 0xFFFFA0;
        }
        if (this.enabled) {
            return 0xE0E0E0;
        }
        return -6250336;
    }

    @Override
    public boolean onMousePressed(int mouseX, int mouseY, int mouseButton) {
        this.containerScreen.field_73882_e.field_71416_A.func_77366_a("random.click", 1.0f, 1.0f);
        if (mouseButton == 0) {
            this.onClick();
        } else if (mouseButton == 1) {
            this.onRightClick();
        } else if (mouseButton == 2) {
            this.onMiddleClick();
        }
        return true;
    }

    public abstract void onClick();

    public void onRightClick() {
    }

    public void onMiddleClick() {
    }
}

