/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.core.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiRender {
    public static void drawHorizontalLine(int x1, int x2, int y, int color) {
        if (x2 < x1) {
            int var5 = x1;
            x1 = x2;
            x2 = var5;
        }
        GuiRender.drawRect(x1, y, x2 + 1, y + 1, color);
    }

    public static void drawVerticalLine(int x, int y1, int y2, int color) {
        if (y2 < y1) {
            int temp = y1;
            y1 = y2;
            y2 = temp;
        }
        GuiRender.drawRect(x, y1 + 1, x + 1, y2, color);
    }

    public static void drawRect(int x1, int y1, int x2, int y2, int color) {
        int temp;
        if (x1 < x2) {
            temp = x1;
            x1 = x2;
            x2 = temp;
        }
        if (y1 < y2) {
            temp = y1;
            y1 = y2;
            y2 = temp;
        }
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)x1, (double)y2, 0.0);
        tessellator.func_78377_a((double)x2, (double)y2, 0.0);
        tessellator.func_78377_a((double)x2, (double)y1, 0.0);
        tessellator.func_78377_a((double)x1, (double)y1, 0.0);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static void drawGradientRect(int x1, int x2, int y1, int y2, int color1, int color2, int zLevel) {
        float a1 = (float)(color1 >> 24 & 0xFF) / 255.0f;
        float r1 = (float)(color1 >> 16 & 0xFF) / 255.0f;
        float g1 = (float)(color1 >> 8 & 0xFF) / 255.0f;
        float b1 = (float)(color1 & 0xFF) / 255.0f;
        float a2 = (float)(color2 >> 24 & 0xFF) / 255.0f;
        float r2 = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float g2 = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(color2 & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78369_a(r1, g1, b1, a1);
        tessellator.func_78377_a((double)x2, (double)y1, (double)zLevel);
        tessellator.func_78377_a((double)x1, (double)y1, (double)zLevel);
        tessellator.func_78369_a(r2, g2, b2, a2);
        tessellator.func_78377_a((double)x1, (double)y2, (double)zLevel);
        tessellator.func_78377_a((double)x2, (double)y2, (double)zLevel);
        tessellator.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    public static void drawCenteredString(FontRenderer fontRenderer, String text, int x, int y, int color) {
        fontRenderer.func_78261_a(text, x - fontRenderer.func_78256_a(text) / 2, y, color);
    }

    public static void drawTexturedModalRect(int x, int y, int u, int v, int width, int height) {
        GuiRender.drawTexturedModalRect(x, y, u, v, width, height, 0.0f);
    }

    public static void drawTexturedModalRect(int x, int y, int u, int v, int width, int height, float zLevel) {
        float xScale = 0.00390625f;
        float yScale = 0.00390625f;
        Tessellator var9 = Tessellator.field_78398_a;
        var9.func_78382_b();
        var9.func_78374_a((double)x, (double)(y + height), (double)zLevel, (double)((float)u * xScale), (double)((float)(v + height) * yScale));
        var9.func_78374_a((double)(x + width), (double)(y + height), (double)zLevel, (double)((float)(u + width) * xScale), (double)((float)(v + height) * yScale));
        var9.func_78374_a((double)(x + width), (double)y, (double)zLevel, (double)((float)(u + width) * xScale), (double)((float)v * yScale));
        var9.func_78374_a((double)x, (double)y, (double)zLevel, (double)((float)u * xScale), (double)((float)v * yScale));
        var9.func_78381_a();
    }
}

