/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.core.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.inventory.GuiContainer;

@SideOnly(value=Side.CLIENT)
public abstract class Control {
    protected GuiContainer containerScreen;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected boolean enabled = true;
    protected boolean visible = true;

    protected Control(GuiContainer containerScreen, int x, int y, int width, int height) {
        this.containerScreen = containerScreen;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public abstract void drawBackground(int var1, int var2, float var3);

    public abstract void drawForeground(int var1, int var2);

    public void drawTooltip(int mouseX, int mouseY, float gameTicks) {
    }

    public GuiContainer getContainerScreen() {
        return this.containerScreen;
    }

    public final int getPosX() {
        return this.x;
    }

    public final int getPosY() {
        return this.y;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getWidth() {
        return this.width;
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public final boolean getVisible() {
        return this.visible;
    }

    public final void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean onMousePressed(int mouseX, int mouseY, int mouseButton) {
        return false;
    }

    public void updateTick(int mouseX, int mouseY) {
    }

    public void onMouseReleased(int mouseX, int mouseY) {
    }

    public boolean onMouseWheel(int mouseX, int mouseY, int movement) {
        return false;
    }

    public boolean onKeyTyped(char characterTyped, int keyPressed) {
        return false;
    }

    public boolean isPointInBounds(int x, int y) {
        return x >= this.x - 1 && x < this.x + this.width + 1 && y >= this.y - 1 && y < this.y + this.height + 1;
    }
}

