/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;

public class ForgeHooks {
    static final List<GrassEntry> grassList = new ArrayList<GrassEntry>();
    static final List<SeedEntry> seedList = new ArrayList<SeedEntry>();
    private static boolean toolInit = false;
    static HashMap<wk, List> toolClasses = new HashMap();
    static HashMap<List, Integer> toolHarvestLevels = new HashMap();
    static HashSet<List> toolEffectiveness = new HashSet();

    public static void plantGrass(aab world, int x, int y2, int z) {
        GrassEntry grass = (GrassEntry)ln.a((Random)world.s, grassList);
        if (grass == null || grass.block == null || !grass.block.f(world, x, y2, z)) {
            return;
        }
        world.f(x, y2, z, grass.block.cz, grass.metadata, 3);
    }

    public static wm getGrassSeed(aab world) {
        SeedEntry entry = (SeedEntry)ln.a((Random)world.s, seedList);
        if (entry == null || entry.seed == null) {
            return null;
        }
        return entry.seed.m();
    }

    public static boolean canHarvestBlock(apa block, sq player, int metadata) {
        if (block.cO.l()) {
            return true;
        }
        wm stack = player.bK.h();
        if (stack == null) {
            return player.a(block);
        }
        List info = toolClasses.get(stack.b());
        if (info == null) {
            return player.a(block);
        }
        Object[] tmp = info.toArray();
        String toolClass = (String)tmp[0];
        int harvestLevel = (Integer)tmp[1];
        Integer blockHarvestLevel = toolHarvestLevels.get(Arrays.asList(block, metadata, toolClass));
        if (blockHarvestLevel == null) {
            return player.a(block);
        }
        return blockHarvestLevel <= harvestLevel;
    }

    public static boolean canToolHarvestBlock(apa block, int metadata, wm stack) {
        if (stack == null) {
            return false;
        }
        List info = toolClasses.get(stack.b());
        if (info == null) {
            return false;
        }
        Object[] tmp = info.toArray();
        String toolClass = (String)tmp[0];
        int harvestLevel = (Integer)tmp[1];
        Integer blockHarvestLevel = toolHarvestLevels.get(Arrays.asList(block, metadata, toolClass));
        return blockHarvestLevel != null && blockHarvestLevel <= harvestLevel;
    }

    public static float blockStrength(apa block, sq player, aab world, int x, int y2, int z) {
        int metadata = world.h(x, y2, z);
        float hardness = block.l(world, x, y2, z);
        if (hardness < 0.0f) {
            return 0.0f;
        }
        if (!ForgeHooks.canHarvestBlock(block, player, metadata)) {
            float speed = ForgeEventFactory.getBreakSpeed(player, block, metadata, 1.0f);
            return (speed < 0.0f ? 0.0f : speed) / hardness / 100.0f;
        }
        return player.getCurrentPlayerStrVsBlock(block, false, metadata) / hardness / 30.0f;
    }

    public static boolean isToolEffective(wm stack, apa block, int metadata) {
        List toolClass = toolClasses.get(stack.b());
        return toolClass != null && toolEffectiveness.contains(Arrays.asList(block, metadata, toolClass.get(0)));
    }

    static void initTools() {
        if (toolInit) {
            return;
        }
        toolInit = true;
        MinecraftForge.setToolClass(wk.u, "pickaxe", 0);
        MinecraftForge.setToolClass(wk.y, "pickaxe", 1);
        MinecraftForge.setToolClass(wk.h, "pickaxe", 2);
        MinecraftForge.setToolClass(wk.J, "pickaxe", 0);
        MinecraftForge.setToolClass(wk.C, "pickaxe", 3);
        MinecraftForge.setToolClass(wk.v, "axe", 0);
        MinecraftForge.setToolClass(wk.z, "axe", 1);
        MinecraftForge.setToolClass(wk.i, "axe", 2);
        MinecraftForge.setToolClass(wk.K, "axe", 0);
        MinecraftForge.setToolClass(wk.D, "axe", 3);
        MinecraftForge.setToolClass(wk.t, "shovel", 0);
        MinecraftForge.setToolClass(wk.x, "shovel", 1);
        MinecraftForge.setToolClass(wk.g, "shovel", 2);
        MinecraftForge.setToolClass(wk.I, "shovel", 0);
        MinecraftForge.setToolClass(wk.B, "shovel", 3);
        for (apa block : wu.c) {
            MinecraftForge.setBlockHarvestLevel(block, "pickaxe", 0);
        }
        for (apa block : xf.c) {
            MinecraftForge.setBlockHarvestLevel(block, "shovel", 0);
        }
        for (apa block : wi.c) {
            MinecraftForge.setBlockHarvestLevel(block, "axe", 0);
        }
        MinecraftForge.setBlockHarvestLevel(apa.at, "pickaxe", 3);
        MinecraftForge.setBlockHarvestLevel(apa.bV, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(apa.aA, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(apa.aB, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(apa.K, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(apa.al, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(apa.L, "pickaxe", 1);
        MinecraftForge.setBlockHarvestLevel(apa.am, "pickaxe", 1);
        MinecraftForge.setBlockHarvestLevel(apa.R, "pickaxe", 1);
        MinecraftForge.setBlockHarvestLevel(apa.S, "pickaxe", 1);
        MinecraftForge.setBlockHarvestLevel(apa.aR, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(apa.aS, "pickaxe", 2);
        MinecraftForge.removeBlockEffectiveness(apa.aR, "pickaxe");
        MinecraftForge.removeBlockEffectiveness(apa.at, "pickaxe");
        MinecraftForge.removeBlockEffectiveness(apa.aS, "pickaxe");
    }

    public static int getTotalArmorValue(sq player) {
        int ret = 0;
        for (int x = 0; x < player.bK.b.length; ++x) {
            wm stack = player.bK.b[x];
            if (stack != null && stack.b() instanceof ISpecialArmor) {
                ret += ((ISpecialArmor)((Object)stack.b())).getArmorDisplay(player, stack, x);
                continue;
            }
            if (stack == null || !(stack.b() instanceof uo)) continue;
            ret += ((uo)stack.b()).c;
        }
        return ret;
    }

    public static boolean onPickBlock(ara target, sq player, aab world) {
        int x;
        wm result = null;
        boolean isCreative = player.ce.d;
        if (target.a == arb.a) {
            x = target.b;
            int y2 = target.c;
            int z = target.d;
            apa var8 = apa.r[world.a(x, y2, z)];
            if (var8 == null) {
                return false;
            }
            result = var8.getPickBlock(target, world, x, y2, z);
        } else {
            if (target.a != arb.b || target.g == null || !isCreative) {
                return false;
            }
            result = target.g.getPickedResult(target);
        }
        if (result == null) {
            return false;
        }
        for (x = 0; x < 9; ++x) {
            wm stack = player.bK.a(x);
            if (stack == null || !stack.a(result) || !wm.a(stack, result)) continue;
            player.bK.c = x;
            return true;
        }
        if (!isCreative) {
            return false;
        }
        int slot = player.bK.j();
        if (slot < 0 || slot >= 9) {
            slot = player.bK.c;
        }
        player.bK.a(slot, result);
        player.bK.c = slot;
        return true;
    }

    public static void onLivingSetAttackTarget(ng entity, ng target) {
        MinecraftForge.EVENT_BUS.post(new LivingSetAttackTargetEvent(entity, target));
    }

    public static boolean onLivingUpdate(ng entity) {
        return MinecraftForge.EVENT_BUS.post(new LivingEvent.LivingUpdateEvent(entity));
    }

    public static boolean onLivingAttack(ng entity, mg src, int amount) {
        return MinecraftForge.EVENT_BUS.post(new LivingAttackEvent(entity, src, amount));
    }

    public static int onLivingHurt(ng entity, mg src, int amount) {
        LivingHurtEvent event = new LivingHurtEvent(entity, src, amount);
        return MinecraftForge.EVENT_BUS.post(event) ? 0 : event.ammount;
    }

    public static boolean onLivingDeath(ng entity, mg src) {
        return MinecraftForge.EVENT_BUS.post(new LivingDeathEvent(entity, src));
    }

    public static boolean onLivingDrops(ng entity, mg source, ArrayList<rh> drops, int lootingLevel, boolean recentlyHit, int specialDropValue) {
        return MinecraftForge.EVENT_BUS.post(new LivingDropsEvent(entity, source, drops, lootingLevel, recentlyHit, specialDropValue));
    }

    public static float onLivingFall(ng entity, float distance) {
        LivingFallEvent event = new LivingFallEvent(entity, distance);
        return MinecraftForge.EVENT_BUS.post(event) ? 0.0f : event.distance;
    }

    public static boolean isLivingOnLadder(apa block, aab world, int x, int y2, int z, ng entity) {
        return block != null && block.isLadder(world, x, y2, z, entity);
    }

    @Deprecated
    public static boolean isLivingOnLadder(apa block, aab world, int x, int y2, int z) {
        return block != null && block.isLadder(world, x, y2, z);
    }

    public static void onLivingJump(ng entity) {
        MinecraftForge.EVENT_BUS.post(new LivingEvent.LivingJumpEvent(entity));
    }

    public static rh onPlayerTossEvent(sq player, wm item) {
        player.captureDrops = true;
        rh ret = player.a(item, false);
        player.capturedDrops.clear();
        player.captureDrops = false;
        ItemTossEvent event = new ItemTossEvent(ret, player);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return null;
        }
        player.a(event.entityItem);
        return event.entityItem;
    }

    public static float getEnchantPower(aab world, int x, int y2, int z) {
        if (world.c(x, y2, z)) {
            return 0.0f;
        }
        apa block = apa.r[world.a(x, y2, z)];
        return block == null ? 0.0f : block.getEnchantPowerBonus(world, x, y2, z);
    }

    static {
        grassList.add(new GrassEntry(apa.ah, 0, 20));
        grassList.add(new GrassEntry(apa.ai, 0, 10));
        seedList.add(new SeedEntry(new wm(wk.T), 10));
        ForgeHooks.initTools();
    }

    static class SeedEntry
    extends lo {
        public final wm seed;

        public SeedEntry(wm seed, int weight) {
            super(weight);
            this.seed = seed;
        }
    }

    static class GrassEntry
    extends lo {
        public final apa block;
        public final int metadata;

        public GrassEntry(apa block, int meta, int weight) {
            super(weight);
            this.block = block;
            this.metadata = meta;
        }
    }
}

