/*
 * Decompiled with CFR 0.152.
 */
package denoflionsx.DenPipes.AddOns.Forestry.Utils;

import denoflionsx.DenPipes.AddOns.Forestry.Pipe.logic.LogicForestry;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.core.ItemInterface;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IIndividual;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;

public class BeeUtils {
    public static Item beeQueenGE;
    public static Item beeDroneGE;
    public static Item beePrincessGE;
    public static final HashMap bees;
    public static IBeeRoot root;
    public static Method getIcon;

    public static boolean isItemStackBee(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        for (ItemStack s : bees.values()) {
            if (!s.func_77969_a(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isItemStackDrone(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return ((ItemStack)bees.get("beeDroneGE")).func_77969_a(stack);
    }

    public static boolean isItemStackPrincessOrQueen(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return BeeUtils.isItemStackPrincess(stack) || BeeUtils.isItemStackQueen(stack);
    }

    public static boolean isItemStackPrincess(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return ((ItemStack)bees.get("beePrincessGE")).func_77969_a(stack);
    }

    public static boolean isItemStackQueen(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return ((ItemStack)bees.get("beeQueenGE")).func_77969_a(stack);
    }

    public static boolean doesBeeMatchSlot(ItemStack bee, LogicForestry.BeeType type) {
        if (!BeeUtils.isItemStackBee(bee)) {
            return false;
        }
        if (BeeUtils.isItemStackDrone(bee)) {
            return type.equals((Object)LogicForestry.BeeType.DRONE);
        }
        if (BeeUtils.isItemStackPrincessOrQueen(bee)) {
            return type.equals((Object)LogicForestry.BeeType.PRINCESS) || type.equals((Object)LogicForestry.BeeType.QUEEN);
        }
        return false;
    }

    public static IBee castItemStackToIBee(ItemStack bee) {
        if (root == null) {
            root = (IBeeRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootBees");
        }
        return root.getMember(bee);
    }

    public static boolean doBeesMatch(ItemStack bee1, ItemStack bee2) {
        if (BeeUtils.isItemStackBee(bee1) && BeeUtils.isItemStackBee(bee2)) {
            IBee one = BeeUtils.castItemStackToIBee(bee1);
            IBee two = BeeUtils.castItemStackToIBee(bee2);
            return one.isGeneticEqual((IIndividual)two);
        }
        return false;
    }

    public static Icon getIconForRenderPass(IAlleleBeeSpecies species, int pass) {
        try {
            return (Icon)getIcon.invoke((Object)beeDroneGE, species, pass);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    static {
        bees = new HashMap();
        try {
            for (Field f : BeeUtils.class.getDeclaredFields()) {
                if (!f.getType().equals(Item.class)) continue;
                ItemStack i = ItemInterface.getItem((String)f.getName());
                f.set(null, i.func_77973_b());
                bees.put(f.getName(), i);
            }
            getIcon = Class.forName("forestry.apiculture.items.ItemBeeGE").getMethod("getIconFromSpecies", IAlleleBeeSpecies.class, Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

