/*
 * Decompiled with CFR 0.152.
 */
package denoflionsx.DenPipes.AddOns.Forestry;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import denoflionsx.DenPipes.AddOns.Forestry.Cards.CardAlleleBase;
import denoflionsx.DenPipes.AddOns.Forestry.Cards.CardAnyDrone;
import denoflionsx.DenPipes.AddOns.Forestry.Cards.CardAnyPrincess;
import denoflionsx.DenPipes.AddOns.Forestry.Cards.CardAnyQueen;
import denoflionsx.DenPipes.AddOns.Forestry.Cards.CardBool;
import denoflionsx.DenPipes.AddOns.Forestry.Cards.CardClosed;
import denoflionsx.DenPipes.AddOns.Forestry.Cards.CardFlowering;
import denoflionsx.DenPipes.AddOns.Forestry.Cards.CardFlowers;
import denoflionsx.DenPipes.AddOns.Forestry.Cards.CardHumidity;
import denoflionsx.DenPipes.AddOns.Forestry.Cards.CardNonBee;
import denoflionsx.DenPipes.AddOns.Forestry.Cards.CardSpecies;
import denoflionsx.DenPipes.AddOns.Forestry.Cards.CardWorkspeed;
import denoflionsx.DenPipes.AddOns.Forestry.Cards.ICard;
import denoflionsx.DenPipes.AddOns.Forestry.ForestryPipe;
import denoflionsx.denLib.Lib.denLib;
import denoflionsx.denLib.Mod.Handlers.WorldHandler.IdenWorldEventHandler;
import denoflionsx.denLib.Mod.Handlers.WorldHandler.WorldEventHandler;
import denoflionsx.denLib.Mod.denLibMod;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.core.IPlugin;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleInteger;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class PluginForestryPipes
implements IPlugin,
IdenWorldEventHandler {
    public static final String speciesKey = "species";
    public static final String workspeedKey = "speed";
    public static final String lifespanKey = "lifespan";
    public static final String fertilityKey = "fertility";
    public static final String toleranceKey = "tolerance";
    public static final String toleranceKey2 = "humidity";
    public static final String flowerKey = "flowers";
    public static final String specialKey = "bool";
    public static final String pollinationKey = "flowering";
    public static final String territoryKey = "territory";
    public static final String effectKey = "effect";
    public static final ArrayList manualControlList = new ArrayList();
    public static final BiMap keyMap = HashBiMap.create();
    public static final HashMap cardRegistry = new HashMap();
    public static final HashMap classMap = new HashMap();
    public static ArrayList extended = new ArrayList();
    public static HashMap dummyAlleles = new HashMap();
    public static File source;

    public static ArrayList getAllCards() {
        ArrayList cards = new ArrayList();
        for (ArrayList c : cardRegistry.values()) {
            cards.addAll(c);
        }
        return cards;
    }

    public static int getCardID(String typeKey, ICard card) {
        return ((ArrayList)cardRegistry.get(typeKey)).indexOf(card);
    }

    public static ICard getCard(String typeKey, int index) {
        return (ICard)((ArrayList)cardRegistry.get(typeKey)).get(index);
    }

    public boolean isAvailable() {
        return true;
    }

    public void preInit() {
    }

    public void doInit() {
    }

    public void postInit() {
        WorldEventHandler.registerHandler((IdenWorldEventHandler)this);
    }

    public void onWorldLoaded() {
        ForestryPipe.proxy.print("Scanning Forestry Allele registry for stuff...");
        for (String s : AlleleManager.alleleRegistry.getRegisteredAlleles().keySet()) {
            for (String key : keyMap.values()) {
                if (manualControlList.contains(key) || !s.toLowerCase().contains(key.toLowerCase())) continue;
                try {
                    Class c = (Class)classMap.get(key);
                    if (c == null) continue;
                    ICard card = (ICard)c.getConstructor(IAllele.class).newInstance(AlleleManager.alleleRegistry.getAllele(s));
                    ((ArrayList)cardRegistry.get(key)).add(card);
                }
                catch (Throwable pokeball) {
                    pokeball.printStackTrace();
                }
            }
        }
        for (String s : AlleleManager.alleleRegistry.getRegisteredAlleles().keySet()) {
            CardAlleleBase card;
            IAllele a;
            CardAlleleBase card2;
            if (s.contains(toleranceKey)) {
                card2 = new CardHumidity(AlleleManager.alleleRegistry.getAllele(s));
                ((ArrayList)cardRegistry.get(toleranceKey2)).add(card2);
            }
            if (s.contains(flowerKey) || s.contains(".flower") && !s.contains(".flowering")) {
                card2 = new CardFlowers(AlleleManager.alleleRegistry.getAllele(s));
                ((ArrayList)cardRegistry.get(flowerKey)).add(card2);
            }
            if (s.contains(workspeedKey) && !s.contains(effectKey)) {
                card2 = new CardWorkspeed(AlleleManager.alleleRegistry.getAllele(s));
                ((ArrayList)cardRegistry.get(workspeedKey)).add(card2);
            }
            if (s.contains(speciesKey) && (a = AlleleManager.alleleRegistry.getAllele(s)) instanceof IAlleleBeeSpecies) {
                card = new CardSpecies(a);
                ((ArrayList)cardRegistry.get(speciesKey)).add(card);
            }
            if (!s.contains(pollinationKey) || !((a = AlleleManager.alleleRegistry.getAllele(s)) instanceof IAlleleInteger)) continue;
            card = new CardFlowering(a);
            ((ArrayList)cardRegistry.get(pollinationKey)).add(card);
        }
        for (CardBool.specials s : CardBool.specials.values()) {
            ((ArrayList)cardRegistry.get(specialKey)).add(new CardBool(s));
        }
        ((ArrayList)cardRegistry.get(speciesKey)).add(new CardAnyPrincess());
        ((ArrayList)cardRegistry.get(speciesKey)).add(new CardAnyDrone());
        ((ArrayList)cardRegistry.get(speciesKey)).add(new CardAnyQueen());
        ((ArrayList)cardRegistry.get(speciesKey)).add(new CardNonBee());
        ((ArrayList)cardRegistry.get(speciesKey)).add(new CardClosed());
        WorldEventHandler.unregisterHandler((IdenWorldEventHandler)this);
    }

    public static ArrayList getClassesThatExtend(File source, Class base) {
        ArrayList classes = new ArrayList();
        try {
            JarFile jarFile = new JarFile(source);
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                JarEntry je = e.nextElement();
                if (je.isDirectory() || !je.getName().endsWith(".class")) continue;
                String className = je.getName().substring(0, je.getName().length() - 6);
                className = className.replace('/', '.');
                if (denLib.debug) {
                    denLibMod.Proxy.print(className);
                }
                Class<?> c = null;
                try {
                    c = Class.forName(className);
                }
                catch (Exception ex) {
                    continue;
                }
                catch (NoSuchFieldError ex) {
                    denLibMod.Proxy.print("Skipping " + className + " due to SideOnly = CLIENT.");
                    ex.printStackTrace();
                    continue;
                }
                if (c.isInterface() || !c.getSuperclass().equals(base)) continue;
                classes.add(c);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return classes;
    }

    public void onWorldEnded() {
    }

    static {
        try {
            int index = -1;
            for (Field f : PluginForestryPipes.class.getDeclaredFields()) {
                if (!f.getType().equals(String.class)) continue;
                String key = f.get(null).toString();
                keyMap.put((Object)(++index), (Object)key);
                cardRegistry.put(key, new ArrayList());
                ForestryPipe.proxy.print("Created card registry " + key);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        manualControlList.add(speciesKey);
        manualControlList.add(toleranceKey2);
        manualControlList.add(specialKey);
        manualControlList.add(flowerKey);
        manualControlList.add(workspeedKey);
        manualControlList.add(pollinationKey);
    }
}

