/*
 * Decompiled with CFR 0.152.
 */
package denoflionsx.DenPipes.AddOns.Forestry.Pipe;

import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.Position;
import buildcraft.api.transport.IPipedItem;
import buildcraft.core.utils.Utils;
import buildcraft.transport.IPipeTransportItemsHook;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.pipes.PipeLogic;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import denoflionsx.DenPipes.API.Annotations.PipeName;
import denoflionsx.DenPipes.AddOns.Forestry.Cards.ICard;
import denoflionsx.DenPipes.AddOns.Forestry.ForestryAddOn;
import denoflionsx.DenPipes.AddOns.Forestry.Pipe.logic.LogicForestry;
import denoflionsx.DenPipes.AddOns.Forestry.Utils.BeeUtils;
import java.util.LinkedList;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

@PipeName(name="Advanced Apiarist Pipe")
public class PipeForestry
extends Pipe
implements IPipeTransportItemsHook {
    public static final BiMap dirs = HashBiMap.create();

    public PipeForestry(PipeTransport transport, PipeLogic logic, int itemID) {
        super(transport, logic, itemID);
        dirs.put((Object)ForgeDirection.UNKNOWN, (Object)Colors.BLANK);
        dirs.put((Object)ForgeDirection.DOWN, (Object)Colors.BLACK);
        dirs.put((Object)ForgeDirection.EAST, (Object)Colors.BLUE);
        dirs.put((Object)ForgeDirection.NORTH, (Object)Colors.GREEN);
        dirs.put((Object)ForgeDirection.SOUTH, (Object)Colors.RED);
        dirs.put((Object)ForgeDirection.UP, (Object)Colors.WHITE);
        dirs.put((Object)ForgeDirection.WEST, (Object)Colors.YELLOW);
    }

    public PipeForestry(int itemID) {
        this((PipeTransport)new PipeTransportItems(), new LogicForestry(), itemID);
    }

    public IIconProvider getIconProvider() {
        return ForestryAddOn.icons;
    }

    public int getIconIndex(ForgeDirection direction) {
        return ((Colors)((Object)dirs.get((Object)direction))).getIconIndex();
    }

    public void setTile(TileEntity tile) {
        super.setTile(tile);
    }

    public LinkedList filterPossibleMovements(LinkedList possibleOrientations, Position pos, IPipedItem item) {
        LinkedList<ForgeDirection> direc = new LinkedList<ForgeDirection>();
        LinkedList<ForgeDirection> defaults = new LinkedList<ForgeDirection>();
        LogicForestry l = (LogicForestry)this.logic;
        for (ForgeDirection d : possibleOrientations) {
            defaults.add(d);
            Colors c = (Colors)((Object)dirs.get((Object)d));
            if (!c.isPrincessNull(l) || !c.isDroneNull(l)) {
                defaults.remove(d);
                if (!BeeUtils.isItemStackBee(item.getItemStack())) continue;
                if (BeeUtils.isItemStackPrincessOrQueen(item.getItemStack())) {
                    if (!BeeUtils.doBeesMatch(item.getItemStack(), c.getBeeForPrincessSlot(l))) continue;
                    direc.add(d);
                    continue;
                }
                if (!BeeUtils.isItemStackDrone(item.getItemStack()) || !BeeUtils.doBeesMatch(item.getItemStack(), c.getBeeForDroneSlot(l))) continue;
                direc.add(d);
                continue;
            }
            int index = c.getCardSlot();
            ICard species = ((ICard[])l.cards.get("species"))[index];
            ICard workspeed = ((ICard[])l.cards.get("speed"))[index];
            ICard lifespan = ((ICard[])l.cards.get("lifespan"))[index];
            ICard fertility = ((ICard[])l.cards.get("fertility"))[index];
            ICard temperature = ((ICard[])l.cards.get("tolerance"))[index];
            ICard humid = ((ICard[])l.cards.get("humidity"))[index];
            ICard bool = ((ICard[])l.cards.get("bool"))[index];
            ICard flower = ((ICard[])l.cards.get("flowers"))[index];
            ICard flowering = ((ICard[])l.cards.get("flowering"))[index];
            ICard territory = ((ICard[])l.cards.get("territory"))[index];
            ICard effect = ((ICard[])l.cards.get("effect"))[index];
            if (species.isNull() && workspeed.isNull() && lifespan.isNull() && fertility.isNull() && temperature.isNull() && humid.isNull() && bool.isNull() && flower.isNull() && flowering.isNull() && territory.isNull() && effect.isNull()) continue;
            defaults.remove(d);
            if (!species.doLogic(item.getItemStack(), l.lock.isLocked) || !workspeed.doLogic(item.getItemStack(), l.lock.isLocked) || !lifespan.doLogic(item.getItemStack(), l.lock.isLocked) || !fertility.doLogic(item.getItemStack(), l.lock.isLocked) || !temperature.doLogic(item.getItemStack(), l.lock.isLocked) || !humid.doLogic(item.getItemStack(), l.lock.isLocked) || !bool.doLogic(item.getItemStack(), l.lock.isLocked) || !flower.doLogic(item.getItemStack(), l.lock.isLocked) || !flowering.doLogic(item.getItemStack(), l.lock.isLocked) || !territory.doLogic(item.getItemStack(), l.lock.isLocked) || !effect.doLogic(item.getItemStack(), l.lock.isLocked)) continue;
            direc.add(d);
        }
        if (!direc.isEmpty()) {
            return direc;
        }
        return defaults;
    }

    public void entityEntered(IPipedItem item, ForgeDirection orientation) {
    }

    public void readjustSpeed(IPipedItem item) {
        item.setSpeed(Utils.pipeNormalSpeed * 20.0f);
    }

    public static enum Colors {
        BLANK(-1, -1),
        BLACK(0, 1),
        WHITE(2, 3),
        RED(4, 5),
        BLUE(6, 7),
        GREEN(8, 9),
        YELLOW(10, 11);

        private int princessSlot;
        private int droneSlot;

        /*
         * WARNING - void declaration
         */
        private Colors() {
            void droneSlot;
            void princessSlot;
            this.princessSlot = princessSlot;
            this.droneSlot = droneSlot;
        }

        public int getIconIndex() {
            return this.ordinal() + 1;
        }

        public int getDroneSlot() {
            return this.droneSlot;
        }

        public int getPrincessSlot() {
            return this.princessSlot;
        }

        public ItemStack getBeeForDroneSlot(LogicForestry logic) {
            return logic.func_70301_a(this.getDroneSlot());
        }

        public ItemStack getBeeForPrincessSlot(LogicForestry logic) {
            return logic.func_70301_a(this.getPrincessSlot());
        }

        public boolean isPrincessNull(LogicForestry logic) {
            return logic.func_70301_a(this.getPrincessSlot()) == null;
        }

        public boolean isDroneNull(LogicForestry logic) {
            return logic.func_70301_a(this.getDroneSlot()) == null;
        }

        public int getCardSlot() {
            return this.ordinal() - 1;
        }
    }
}

